function spfreq,input,verbose=verbose
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Converts spatial frequency [1/rad] to projected baseline length [M lambda]
; and vice versa. It turns out that the latter is just 1e6 * 1/rad
;
output=input
index=where(input lt 1e4,count)
; These input values are projected baseline lengths in millions of wavelengths
if count ge 1 then begin
	if keyword_set(verbose) then $
	print,'Frequency [1/rad] for input values of proj. lengths in Mlambda:'
	output[index]=input[index]*1e6
	if keyword_set(verbose) then print,output[index]
endif
;
index=where(input ge 1e4,count)
; These input values are spatial frequencies in 1/rad
if count ge 1 then begin
	if keyword_set(verbose) then $
	print,'Proj. baseline [Mlambda] for input values of spatial frequency: 1/RAD'
	output[index]=input[index]/1e6
	if keyword_set(verbose) then print,output[index]
endif
;
if not keyword_set(verbose) then return,output else return,''
;
end
