function stationdelay,uvw
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; This function computes station based delays from baseline delays. It should
; only be used for astrometric delays, since it does not do a least-squares
; reduction. The delay of the first station in the first baseline is set to 0.
; Note that the station offset (the path to the array center) difference 2-1
; is subtracted from station j, which is equivalent to adding it to
; station i. If the difference is positiv, station i has to put in extra
; delay. Note that a delay line position is positive if it puts in extra
; delay; the position is zero if the cart is at the entrance window, and it
; is +35 m (for NPOI) if the cart is all the way back at the end of the delay
; line tank.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
n=n_elements(uvw[0,0,0,0,*])
d=dblarr(GenConfig.NumSid,n)
s=strarr(n_elements(d[*,0]))
;
REPEAT begin
for ob=0,GenConfig.NumOutBeam-1 do begin
for bl=0,GenConfig.NumBaseline[ob]-1 do begin
	i=where(GenConfig.StationId[0:GenConfig.NumSid-1] $
                eq strmid(GenConfig.BaselineId[bl,ob],0,3))
	i=i[0]
	j=where(GenConfig.StationId[0:GenConfig.NumSid-1] $
                eq strmid(GenConfig.BaselineId[bl,ob],4,3))
	j=j[0]
	if s[i] ne '' and s[j] eq '' then begin
		s[j]=GenConfig.StationId[j]
		d[j,*]=d[i,*]+uvw[ob,0,bl,2,*]*GenConfig.Wavelength[0,ob]- $
	              (GenConfig.StationCoord[3,j]-GenConfig.StationCoord[3,i])
	endif else if s[i] eq '' and s[j] ne '' then begin
		s[i]=GenConfig.StationId[i]
		d[i,*]=d[j,*]-uvw[ob,0,bl,2,*]*GenConfig.Wavelength[0,ob]+ $
		      (GenConfig.StationCoord[3,j]-GenConfig.StationCoord[3,i])
	endif else if s[i] eq '' and s[j] eq '' then begin
		s[i]=GenConfig.StationId[i]
		s[j]=GenConfig.StationId[j]
		d[i,*]=0
		d[j,*]=uvw[ob,0,bl,2,*]*GenConfig.Wavelength[0,ob]- $
		      (GenConfig.StationCoord[3,j]-GenConfig.StationCoord[3,i])
	endif
endfor
endfor
icheck=0
for i=0,GenConfig.NumSid-1 do if s[i] eq '' then icheck=1
ENDREP until icheck eq 0
;
return,d
;
end
