function stellarfluxes,model,lamda,ld_coeffs
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; For a given stellar model, return the fluxes for given wavelengths lamda[m]
; as well as limb darkening coefficients according to the model type.
; Note that all stellar disk fluxes are scaled with the squared diameter
; if the effective temperature (T) is non-zero, except if T=-5555, which
; is the value of T assigned by readmodel if T=0 on input (req. by PEARL).
;
; Flat flux distribution, no limb darkening (if applicable)
if model.teff eq 0 then begin
	ld_coeffs=dblarr(n_elements(lamda))
	fluxes=dblarr(n_elements(lamda))+1
;
; Black body (standard, negative teff)
endif else if model.teff lt 0 then begin
	ld_coeffs=dblarr(n_elements(lamda))
	fluxes=blackbody(abs(model.teff),lamda)
;
; Limb-darkening coefficients from Kurucz model atmospheres
endif else if abs(model.type) ge 5 and abs(model.type) le 7 then begin
	ld_coeffs=kurucoeffs(model,lamda*1d9,fluxes)
;
; Limb-darkening coefficients from Aufdenberg model atmospheres
endif else if abs(model.type) eq 8 then begin
	ld_coeffs=jasoncoeffs(model,lamda*1d9,fluxes)
;
; Limb-darkening coefficients and fluxes from Van Hamme
endif else begin
	ld_coeffs=limblinear(model.teff,model.logg,lamda*1d9,fluxes)
endelse
;
; Scale fluxes with square of diameter for physical models
if model.teff ne 0 and model.teff ne -5555 then begin
	if abs(model.type) ge 1 and abs(model.type) le 11 then begin
		fluxes=fluxes*model.diameter^2*model.ratio
	endif
endif
;
return,fluxes
;
end
;
