pro storenight,mode,file=file
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Store one night's data (scans) in memory (or on disk if too big).
; These data can be retrieved later with loadnight.
; mode=10:	Store new night (default)
; mode=11:	Overwrite existing night
;
; Note that GenInfo and bufferinfo already have to have an entry for
; this currently loaded night before this function can be called!
;
; Also note: as a general rule, OYSTER does not buffer a night if it is the
; only one. The buffer should only be used in case there are 2 or more nights
; to be stored.
;
common LocalAmoebaBuffer,BUFFERSIZE,BUFFERLIMIT
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
if n_elements(file) eq 0 then file='' else file=string(file)
;
; Determine which index of bufferinfo is in use by unique identifier
; composed of date, systemid, and configid
cdate=checkdate()
arrayid=GeoParms.systemid
configid=GenConfig.configid
j=where(GenInfo.date eq cdate $
    and GeoInfo.SystemId eq arrayid $
    and GenInfo.ConfigId eq configid)
j=j[0]
;
if n_elements(mode) eq 0 then mode=10L
mode=long(mode)
;
if mode eq 10 or j lt 0 then begin
	mode=10L
	r=size(bufferinfo)
	if r[2] ne 8 then begin	; Initialize if bufferinfo is not a structure
		j=0
		freememory
		bufferinfo=replicate(nightinfo(),1)
		GeoInfo=replicate(GeoParms,1)
		GenInfo=replicate(allocgenconfig(/geninfo),1)
		GeoInfo[j]=GeoParms
		G=GenInfo[j]
		struct_assign,GenConfig,G
		GenInfo[j]=G
	endif
	if j lt 0 then begin
		print,'Night had not been allocated yet...'
		bufferinfo=[bufferinfo,nightinfo()]
		GeoInfo=[GeoInfo,GeoParms]
		GenInfo0=GenInfo
		GenInfo=replicate(allocgenconfig(/geninfo),1+n_elements(GenInfo))
		for k=0,n_elements(GenInfo0)-1 do begin
			G=GenInfo[k]
			struct_assign,GenInfo0[k],G
			GenInfo[k]=G
		endfor
		j=k
		struct_assign,GenConfig,G
		GenInfo[j]=G
	endif
endif
;
bufferinfo[j].file=file
;
if n_elements(BUFFERLIMIT) eq 0 then BUFFERLIMIT=500000000L
if n_elements(BUFFERSIZE) eq 0 then BUFFERSIZE=0L
;
if sizeof(scans)+BUFFERSIZE gt BUFFERLIMIT then begin
;
	bufferinfo[j].xdr=1
	save,scans,genconfig,filename=cdate+arrayid+configid+'.xdr'
;
endif else begin
;
	bufferinfo[j].xdr=0
;
	if mode ne 11 then $
	BUFFERSIZE=BUFFERSIZE+sizeof(scans)+sizeof(genconfig)
;
	bufferinfo[j].nigc.numsid=genconfig.numsid
	bufferinfo[j].nigc.numoutbeam=genconfig.numoutbeam
;
	bufferinfo[j].nigc.maxtriple=n_elements(genconfig.triplenumchan)
	bufferinfo[j].nigc.maxbaseline=n_elements(genconfig.baselineid[*,0])
	bufferinfo[j].nigc.maxchannel=n_elements(genconfig.wavelength[*,0])
	bufferinfo[j].nigc.maxconfig=n_elements(genconfig.config)
;
	n=0
	fields=tag_names(genconfig)
	for i=0,n_elements(fields)-1 do begin
		data=genconfig.(i)
		dims=size(data)
		if dims[dims[0]+1] eq 7 then begin
                        sl=strlen(data)
                        index=where(sl eq 0,count)
                        if count gt 0 then data[index]=' '
			bufferinfo[j].nigc.maxlen(n)=max(strlen(data))
			n=n+1
		endif
		bufferinfo[j].nigc.size(i,0:n_elements(dims)-1)=dims
		status=linknload(!external_lib,'nightbuffer', $
			dims,data,cdate+arrayid+configid,mode)
		if status then begin
			print,'***Error(STORENIGHT): error storing GenConfig!'
			return
		endif
	endfor
;
	bufferinfo[j].nisc.numscan=n_elements(scans)
;
	n=0
	fields=tag_names(scans)
	for i=0,n_elements(fields)-1 do begin
		data=scans.(i)
		dims=size(data)
		if dims[dims[0]+1] eq 7 then begin
                        sl=strlen(data)
                        index=where(sl eq 0,count)
                        if count gt 0 then data[index]=' '
			bufferinfo[j].nisc.maxlen(n)=max(strlen(data))
			n=n+1
		endif
		bufferinfo[j].nisc.size(i,0:n_elements(dims)-1)=dims
		status=linknload(!external_lib,'nightbuffer', $
			dims,data,cdate+arrayid+configid,mode)
		if status then begin
			print,'***Error(STORENIGHT): error storing scans!'
			return
		endif
	endfor
;
endelse
;
end
