pro storenpoiconfig,stations,delaylineids,cterm
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Used to store C-term measurements in data base.
; Currently configured to accept only baseline/station triples as
; listed in procedure startconfig.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
systemid='NPOI'
;
numsid=n_elements(stations)
numoutbeam=1
maxnumtriple=1
numbaseline=((numsid-1)*numsid)/2
maxspecchan=32
numconfig=1
genconfig=allocgenconfig(numsid,numoutbeam,maxnumtriple,numbaseline,maxspecchan,
;
genconfig.beamcombinerid=2
genconfig.numsid=numsid
genconfig.numoutbeam=numoutbeam
genconfig.numbaseline=numbaseline
genconfig.stationid[0:numsid-1]=stations
genconfig.delaylineid[0:numsid-1]=delaylineids
get_stationtable
genconfig.stationcoord[3,*]=cterm
l=0
for i=0,genconfig.numsid-2 do begin
for j=i+1,genconfig.numsid-1 do begin
	genconfig.baselineid[l,0]=stations[i]+'-'+stations[j]
	l=l+1
endfor
endfor
;
save,genconfig, $
	filename=!oyster_dir+'npoi/opd/'+string(systime(/julian), $
						format='(f16.8)')+'.xdr'
; Wait for any background processes to finish
wait,1
;
end
