function strict_configid,configid_in
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return a standard config id, including the baseline layout instead of just
; the station layout. GenConfig corresponding to loaded data must be defined.
;
; The configid should be composed of:
; array name, instrument, mode, baseline layout
; Examples:
; NPOI, 6way,
; NPOI, CLASSIC or VISION, Full or Halpha,
; VLTI, MATISSE, L-HR, UT3-UT4_UT1-UT2_UT2-UT3_UT2-UT4_UT1-UT3_UT1-UT4
; VLTI, GRAVITY, FT/SC, UT3-UT4_UT1-UT2_UT2-UT3_UT2-UT4_UT1-UT3_UT1-UT4
;
; Input examples:
; MATISSE_L_UT1-UT2-UT3-UT4, VLTI/MATISSE-N-LR, MATISSE-N-LR
; GRAVITY_FT_UT1-UT2-UT3-UT4
; GRAVITY_SC_UT1-UT2-UT3-UT4, VLTI, GRAVITY-LR
; PIONIER_GRI6_AD0-AG2-AJ3-AK0
; N00-N05-N10-W06-W08-W10 (NPOI), NPOI/3way
; E03-AC0-AE0-AW0, NPOI/6way
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
configid=configid_in
;
instrumentid=instrument_id(systemid)
words=nameparse(configid,'_')
if n_elements(words) eq 2 and words[0] eq instrument_id(systemid) then $
	instrumentid=configid
;
if !owner eq 'chummel' then begin
	print,'---------------------------------------------------------------'
	print,'This is function strict_configid. Input is: '+configid
	print,'This is function strict_configid. SystemID is: '+systemid
	print,'This is function strict_configid. Instrument is: ' $
						+instrument_id(systemid)
	baselineids=''
	for i=0,genconfig.numoutbeam-1 do begin
	for j=0,genconfig.numbaseline[i]-1 do $
		baselineids=[baselineids,genconfig.baselineid[j,i]]
	endfor
	baselineids=baselineids[1:n_elements(baselineids)-2]
	syswords=nameparse(systemid,'/')
	configid=syswords[0]+'_'+instrumentid+'_' $
		+unique_station_config(baselineids)
	print,'Suggested new configid:'
	print,configid
	print,'---------------------------------------------------------------'
endif
;
; New config ID not yet verified...
return,configid_in
;
end
