pro strucfunc,series,sampling_int,dt,sf,acceleration=factor
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
if not keyword_set(factor) then factor=1.0 else factor=float(factor)
;
n=n_elements(series)
sf=dblarr(n-1)
dt=(dindgen(n-1)+1)*sampling_int
;
num_max=n/factor
;
for i=1l,n-1 do begin
;	series_shift=shift(series,-i)
;	sf(i-1)=avg((series_shift(0:n-1-i)-series(0:n-1-i))^2)
;	sf(i-1)=avg((series(i:n-1)-series(0:n-1-i))^2)
	factor=ceil((n-i)/num_max)
	index=lindgen((n-i)/factor)*factor
	sf[i-1]=avg((series[index+i]-series[index])^2)
endfor
;
!p.multi=0
!p.charsize=1.5
;
plot,dt,sf,/xlog,/ylog, $
	xtitle='Interval [s]'
;
end
