function summe,x,dim,sdev=sdev
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; This function sums all elements along dimension dim (first is 0) and
; returns the remainder of the matrix. It is identical to total() in IDL,
; but should be used instead of total() under PV-WAVE since that
; implementation does not have the dim parameter.
;
; If the input array is complex, the standard deviations (sdev) are
; computed as the standard deviations of the radius and phase*radius,
; i.e. as the major and minor axes of the uncertainty ellipse after
; rotation by the mean phase angle to phase=0.
;
forward_function cphase
;
i_complex=sqrt(complex(-1,0))
;
result=size(x)
if result[n_elements(result)-2] eq 6 then c=1 else c=0
if n_elements(dim) eq 0 then begin
	xt=total(x)
	if n_elements(x) ge 2 then begin
	if c then begin
		xr=x*exp(-i_complex*cphase(xt))
		sdev=complex(stddev(float(xr)),stddev(imaginary(xr)))
;		sdev=complex(stddev(float(xr)), $
;		             atan(stddev(imaginary(xr)),abs(xt)/n_elements(x)))
	endif else begin
		if total(x-median(x)) ne 0 then $
		sdev=stddev(x)
	endelse
	endif
	return,total(x)
endif
;
n=result[1+dim]
if dim eq 0 then k=1 else k=produkt(result[1:dim])
l=k*n
result[dim+1]=1
xt=reform(make_array(size=result))
sdev=xt
m=n_elements(xt)
for i=0L,m-1 do begin
	index=lindgen(n)*k+(i mod k)+(i/k)*l
	xt[i]=total(x[index])
	if n ge 2 then begin
	if c then begin
		xr=x[index]*exp(-i_complex*cphase(xt[i]))
		sdev[i]=complex(stddev(float(xr)),stddev(imaginary(xr)))
;		sdev(i)=complex(stddev(float(xr)), $
;			 atan(stddev(imaginary(xr)),abs(xt(i))/n))
	endif else begin
		if total(x[index]-median(x[index])) ne 0 then $
		sdev[i]=stddev(x[index])
	endelse
	endif
endfor
;
return,xt
;
end
