function system_id,sysid
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return the common OYSTER system name for sysid. If not found,
; return sysid unchanged. Return SystemId if no input provided.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if n_elements(sysid) eq 0 then sysid=''
;
if strpos(strupcase(sysid),'MARK') ge 0 then return,'Mark3'
if strpos(strupcase(sysid),'PTI') ge 0 then return,'PTI'
if strpos(strupcase(sysid),'CHARA') ge 0 then return,'CHARA'
if strpos(strupcase(sysid),'IOTA') ge 0 then return,'IOTA'
if strpos(strupcase(sysid),'KECK') ge 0 then return,'Keck'
if strpos(strupcase(sysid),'T-RECS') ge 0 then return,'T-ReCS'
if strpos(strupcase(sysid),'NACO') ge 0 then return,'NACO'
if strpos(strupcase(sysid),'VLTI') ge 0 then return,'VLTI'
if strpos(strupcase(sysid),'NPOI') ge 0 then return,'NPOI'
if strpos(strupcase(sysid),'COAST') ge 0 then return,'COAST'
if strpos(strupcase(sysid),'SUSI') ge 0 then return,'SUSI'
if strpos(strupcase(sysid),'ISI') ge 0 then return,'ISI'
;
; No match found
return,sysid
;
; No match found; if input was undefined, this function is used to set it
if n_elements(SystemId) ne 0 then return,SystemId
;
end
