function teff_bv,bv,sg=sg
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Returns Teff as a function of (B-V) according to polynomial fits
; given in Flower, 1996 (Table 5), corrected by Torres 2010 (Table 2).
;
; For main-sequence stars, use the newer coefficients of Boyajian et al. 2013
; for spectral types later then A0.
;
; For supergiants, use the Flower & Torres polynomial.
;
if n_elements(sg) eq 0 then sg=0
;
bv=double(bv)
logt=bv*0
;
; Coefficients for AFGK dwarfs (Boyajian et al. 2013)
c=[9552,-17443,44350,-68940,57338,-24072,4009] & c=double(c)
index=where(bv ge 0,count)
if count gt 0 then logt[index]=alog10(poly(bv[index],c))
;
; Coefficients for dwarfs, subgiants, and giants (Flower 1996, Torres 2010)
c=[3.979145,-0.654499,1.740690,-4.608815,6.792600,-5.396910,2.192970,-0.359496]
c=double(c)
index=where(bv lt 0,count)
if count gt 0 then logt[index]=poly(bv[index],c)
;
if not sg then return,10^logt
;
; Coefficients for supergiants
if sg then $
c=[4.0125597,-1.055043,2.133395,-2.459770,1.349424,-0.283943]
c=double(c)
logt=poly(bv,c)
;
return,10^logt
;
end
