function teff_dwarf,type
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Estimate Teff [K] for dwarfs from spectral type.
; Input type as used by OYSTER: O0:00, B0:10, A0:20, F0:30, G0:40, K0:50, M0:60
;
type=float(type)
teff=fltarr(n_elements(type))
;
; A0 to K0 (Boyajian et al. 2012a)
index=where(type ge 20 and type lt 50,count)
c=[9393.59,-490.25,36.44,-1.44,0.0208]
if count gt 0 then teff[index]=poly(ft_tabby(type[index]),c)
;
; K0 to M5.5 (Boyajian et al. 2012b)
ft=[findgen(6)+50,57,findgen(9)*0.5+60,65.5]
tf=[5347,5147,5013,4680,4507,4436,3961,3907, $
    3684,3497,3674,3464,3442,3412,3104,3222,3054]
tf=float(tf)
index=where(type ge 50,count)
if count gt 0 then teff[index]=interpol(tf,ft,type[index])
;
; All other spectral types (via B-V calibration)
index=where(type lt 20 or type gt 65.5,count)
if count gt 0 then teff[index]=teff_bv(bv_dwarf(type[index]))
;
return,teff
;
; Old code
d_type=''       ; Spectral type
d_ft=0.         ; Floating spectral type
d_t=0.          ; log(T_eff/K)
d_c=0.          ; Color (U-B, B-V, etc.)
d_mv=0.         ; M_V
d_mb=0.         ; M_bol
status=dc_read_free(!oyster_dir+'starbase/spec_par.V', $
        d_type,d_ft,d_t,d_c,d_mv,d_mb, $
        /col,resize=[1,2,3,4,5],ignore=['!'])
;
; First version (polynomial interpolation)
d_r=poly_fit(d_ft,d_t,4)
; return,10^poly(type,d_r)
;
; Plot of Teff-spectral type relationship
plot=0
if plot then begin
!p.charsize=1.5
window,/free
x=findgen(70)
y=poly(x,d_r)
y=spline(d_ft,d_t,x)
plot,x,y,title='Dwarfs',psym=0, $
       xtitle='Integer Spectral type',ytitle='log(Effective temperature/K)'
oplot,d_ft,d_t,psym=6
endif
;
; Second version (spline interpolation)
si=sort(type)
teff=fltarr(n_elements(type))
teff[si]=10^spline(d_ft,d_t,type[si])
return,teff
;
end
