function teff_giant,type
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Estimate Teff [K] for giants from spectral type.
; Input type as used by OYSTER: O0:00, B0:10, A0:20, F0:30, G0:40, K0:50, M0:60
;
type=float(type)
teff=fltarr(n_elements(type))
;
; G8 to M8 (van Belle et al. 1999)
index=where(type ge 48 and type le 68,count)
if count gt 0 then teff[index]=-109.0*ft_gerard(type[index])+4570
;
; All other spectral types (via B-V calibration)
index=where(type lt 48 or type gt 68,count)
if count gt 0 then teff[index]=teff_bv(bv_giant(type[index]))
;
return,teff
;
; Old code
g_type=''
g_ft=0.
g_t=0.
g_c=0.
g_mv=0.
g_mb=0.
status=dc_read_free(!oyster_dir+'starbase/spec_par.III', $
        g_type,g_ft,g_t,g_c,g_mv,g_mb, $
        /col,resize=[1,2,3,4,5],ignore=['!'])
;
; First version (polynomial interpolation)
g_r=poly_fit(g_ft,g_t,4)
; return,10^poly(type,g_r)
;
; Plot of M_V-spectral type relationship
plot=0
if plot then begin
!p.charsize=1.5
window,/free
x=findgen(70)
; y=poly(x,g_r)
y=spline(g_ft,g_t,x)
plot,x,y,title='Giants',psym=0, $
        xtitle='Integer Spectral type',ytitle='log(Effective temperature/K)'
oplot,g_ft,g_t,psym=6
endif
;
; Second version (spline interpolation)
si=sort(type)
teff=fltarr(n_elements(type))
teff[si]=10^spline(g_ft,g_t,type[si])
return,teff
;
end
