function teff_mass,mass
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Use mass-effective temperature relationship for main-sequence stars to predict
; effective temperature (K) from mass. Input data from Torres et al. 2010.
;
; The Sun is 5777 K, but we get 5454 K...?
;
; New version using data from Torres et al. 2010
status=dc_read_free(!oyster_dir+'starbase/torres.dat', $
	m,em,rad,erad,teff,eteff,logg,elogg,logl,elogl,mv,emv, $
	/col,ignore=['!'])
; Exclude slightly evolved stars with log(g) < 4.3/4.1 for mass <10/>10
index=where((m le 10 and logg gt 4.3) or (m gt 10 and logg gt 4.1))
r=poly_fit(alog10(m[index]),alog10(teff[index]),3,yfit)
if n_elements(mass) eq 0 then begin
	plot,alog10(m),alog10(teff),psym=1,yrange=[3,5], $
		title='Data from Torres et al. 2010', $
		xtitle='log(mass)',ytitle='log(Teff)',charsize=1.5
	oplot,alog10(m[index]),alog10(teff[index]),psym=1,color=tci(3)
	oplot,alog10(m[index]),yfit,psym=0,color=tci(3)
;	Overplot numerical relation from Allen's A. Q., p. 382
	lm=findgen(100)/50-0.5
	lr=fltarr(100)
	index=where(lm gt 0.12)
	lr[index]=0.640*lm[index]+0.011
	index=where(lm le 0.12)
	lr[index]=0.917*lm[index]-0.020
	ll=3.8*lm+0.08
	ltf=(ll+4*alog10(5777)-2*lr)/4
	oplot,lm,ltf,psym=0,color=tci(1)
	return,0
endif else $
return,10^poly(alog10(mass),r)
;
end
