function teff_star,spectrum
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
n=n_elements(spectrum)
if n eq 0 then return,-1
;
teff=fltarr(n)
spec_parse,spectrum,type,class,type2,class2
;
; Dwarfs
index=dwarfs(class,type,1)
if index[0] ne -1 then teff[index]=teff_dwarf(type[index])
;
; Giants
index=giants(class,type,1)
if index[0] ne -1 then teff[index]=teff_giant(type[index])
;
; Super giants
index=supergiants(class,type,1)
if index[0] ne -1 then teff[index]=teff_supergiant(type[index])
;
; Wolf-Rayet
index=supergiants(class,type,1)
if index[0] ne -1 then teff[index]=teff_wr(type[index])
;
if n eq 1 then teff=teff[0]
return,teff
;
end
