pro teff_stars
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Derive effective temperature for all stars from spectral classification.
; Store results in startable.
;
common StarBase,startable,notes
;
; We should initialize Teff to zero
startable.teff=0
;
index=dwarfs(startable.class,startable.type,1)
if index[0] ne -1 then $
startable(index).teff=teff_dwarf(startable[index].type)
;
index=giants(startable.class,startable.type,1)
if index[0] ne -1 then $
startable(index).teff=teff_giant(startable[index].type)
;
index=supergiants(startable.class,startable.type,1)
if index[0] ne -1 then $
startable(index).teff=teff_supergiant(startable[index].type)
;
end
