function teff_supergiant,type
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Estimate Teff [K] for super giants from spectral type.
; Input type as used by OYSTER: O0:00, B0:10, A0:20, F0:30, G0:40, K0:50, M0:60
;
type=float(type)
teff=fltarr(n_elements(type))
;
; G8 to M8 (van Belle et al. 1999)
index=where(type ge 48 and type le 68,count)
if count gt 0 then teff[index]=-109.0*ft_gerard(type[index])+4570
;
; All other spectral types (via B-V calibration), limit type < 75
index=where(type lt 48 or type gt 68,count)
if count gt 0 then teff[index]=teff_bv(bv_supergiant(type[index] < 75),/sg)
;
return,teff
;
; Old code
sg_type=''
sg_ft=0.
sg_t=0.
sg_c=0.
sg_mv=0.
sg_mb=0.
status=dc_read_free(!oyster_dir+'starbase/spec_par.Iab', $
        sg_type,sg_ft,sg_t,sg_c,sg_mv,sg_mb, $
        /col,resize=[1,2,3,4,5],ignore=['!'])
;
; sg_r=poly_fit(sg_ft,sg_t,4)
;
; Plot of M_V-spectral type relationship
plot=0
if plot then begin
!p.charsize=1.5
window,/free
x=findgen(70)
; y=poly(x,sg_r)
y=spline(sg_ft,sg_t,x)
plot,x,y,title='Super-Giants',psym=0, $
        xtitle='Integer Spectral type',ytitle='log(Effective temperature/K)'
oplot,sg_ft,sg_t,psym=6
endif
;
si=sort(type)
teff=fltarr(n_elements(type))
teff[si]=10^spline(sg_ft,sg_t,type[si])
return,teff
; return,10^poly(type,sg_r)
;
end
