function teff_vmk,vmk
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute teff=f(V-K) from Mozurkewich et al. 2003.
;
; Equation 4
lteff=3.972-0.176*vmk+0.024*vmk^2-0.0013*vmk^3
;
min=-0.5 ; Minimum allowable (V-K)
index=where(vmk lt min,count)
count=0 ; Do not limit at this time
if count gt 0 then begin
	ltmax=3.972-0.176*min+0.024*min^2-0.0013*min^3
	print,'Warning(TEFF_VMK): results not reliable for (V-K) < -0.25!'
	lteff[index]=ltmax
	print,'Maximum T_eff limited to: ',10^ltmax
endif
;
return,10^lteff
;
end
