function teff_wr,type_in
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Estimate Teff [K] for Wolf-Rayet stars based on Schmutz et al. 1982
; We assume that T_eff can be extrapolated linearly from WC 9,8,7 to WC 6 and 5.
;
type=float(abs(type_in))
teff=fltarr(n_elements(type))
;
wc_teff=[22e3,26e3,30e3,34e3,38e3]
wc_type=[9,8,7,6,5]
r=poly_fit(wc_type,wc_teff,1)
;
return,poly(type,r)
;
return,teff
;
end
