pro teffmap
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Derive new effective temperatures for each non-zero image pixel.
; Multiply each channel image by the SED so that the total flux is the SED.
;
common PearlData,ov,ow,uc,vc,cv,mv,si,bi,ci,wl,bw,fl,db,cb,dm,rm,cm,cc,rt,rg,rf
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if total(cm.maps.map) eq 0 then return
;
; Initialize Teff map
teff0=median(cm.teff)
cm.teff=teff0
;
print,'Computing new effective temperature map...',format='(a,$)'
;
fm=cm
nc=n_elements(fm.maps)-1
; Average clean beam
cbt=total(cb.maps.map,3)/nc
; Largest clean beam
j=where(wl eq max(wl)) & j=j[0]
cbt=cb.maps[j+1].map
;
; It is important to convolve all channels maps with the same CB
for ch=1,nc do begin
	fm.maps[ch].map=convol(cm.maps[ch].map,cbt,/edge_wrap,/center)
	tfm=total(fm.maps[ch].map)
	fm.maps[ch].map=fm.maps[ch].map/tfm*fl[ch-1]
endfor
;
; Find the indices of clean components in the combined map
tfm=total(fm.maps.map,3)
index=where(tfm gt max(tfm)*0.01,count)
;
teff=fltarr(count)
x=wl*1e-9
tgran=50.0
;
; Weighting vector to give more weight to the edges
w=cos(abs(x-x[0])/(max(x)-min(x))*2*!pi)+2
;
; wset,34	; is that needed?
for k=0,count-1 do begin
	ij=whereindex(index[k],tfm)
	y=fm.maps[1:nc].map(ij[0],ij[1])
	z=where(y eq 0,count)
	if count eq 0 then begin
		z=where(y eq max(y))
		a=[wien(x[z[0]]),1]
		blackbody_pro,x,a,f
		a[1]=median(y/f)
		r=curvefit(x,y,w,a,function_name='blackbody_pro', $
			/noderiv,itmax=100,status=s)
		teff[k]=nint(a[0]/tgran)*tgran
	endif else begin
		teff[k]=teff0
	endelse
endfor
cm.teff[index]=teff
;
; Apply median filter over half the kernel patch
r=size(cbt)
r=fix(sqrt(r[1]*r[2])/2)
cm.teff=median(cm.teff,r)
cc.teff=cm.teff
;
; (Re)Initialize rt and rf
pearlinit,cm.teff
;
print,'done.'
;
end
