function theta2r,latitude,omega
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute radius as a function of latitude (equator at zero, pole at 90),
; using equation 8 of van Belle et al. 2001.
;
rad=180/!pi
cl=(90-latitude)/rad
index=where(cl eq 0,count)
if count gt 0 then cl[index]=0.01
;
r=(3/(omega*sin(cl)))*cos((acos(-omega*sin(cl))+4*!pi)/3)
if count gt 0 then r[index]=1
;
return,r
;
end
