function thiele
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Use Thiele-Innes method to estimate orbital parameters once the apparent
; ellipse has been fitted to the positions.
;
common FitAstrometry,ellipse_options,orbit_options,e_parms,o_parms
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
o_parms=dblarr(8)
RAD=180/pi_circle
;
; Check inputs
num_scan=n_elements(positions)
if num_scan eq 0 then begin
	print,'***Error(THIELE): no data!'
	return,o_parms
endif
if n_elements(e_parms) eq 0 then begin
	print,'***Error(THIELE): ellipse parms undefined!'
	return,o_parms
endif
if total(e_parms) eq 0 then begin
	print,'***Error(THIELE): ellipse parms zero!'
	return,o_parms
endif
;
; Set and sort data
jd=positions.jd
theta=positions.theta
index=where(theta lt 0,count)
if count gt 0 then theta[index]=theta[index]+2*pi_circle
rho=positions.rho
s=sort(jd)
jd=jd[s]
theta=theta[s]
rho=rho[s]
;
; Determine orbital sense
dtheta=theta-shift(theta,1)
index=where(dtheta lt -pi_circle,count)
if count gt 0 then dtheta[index]=dtheta[index]+2*pi_circle
index=where(dtheta ge 0,count1)
index=where(dtheta lt 0,count2)
if count1 gt count2 then begin
	o_parms[7]=1
	print,'Orbit is PROGRADE.'
endif else begin
	o_parms[7]=-1
	print,'Orbit is RETROGRADE.'
endelse
;
; Compute cumulative area a of fit-ellipse
n=3600
p=dindgen(n)*2*pi_circle/n
if o_parms[7] eq -1 then p=2*pi_circle-p
r=ellipse(e_parms[2],e_parms[3],p-e_parms[4])
x=r*sin(p)+e_parms[0]
y=r*cos(p)+e_parms[1]
a=dblarr(n)
for i=1,n-1 do $
	a[i]=sqrt(total(crossp([x[i],y[i],0.0],[x[i-1],y[i-1],0.0])^2))/2+a[i-1]
p=atan(x,y)
; index=where(p lt 0,count)
; if count gt 0 then p(index)=p(index)+2*pi_circle
p=remsteps(p,2*pi_circle)
index=where(p lt -pi_circle,count)
if count gt 0 then p=p+2*pi_circle
r=sqrt(x^2+y^2)
e_area=e_parms[2]*e_parms[3]*pi_circle
;
; Use Kepler's second law to estimate period
; Compute cummulative area for observed positions...
area=dblarr(num_scan)
for i=0,num_scan-1 do begin
	dp=abs(theta[i]-p)
	area[i]=a[where(dp eq min(dp))]
endfor
; ...We combine pairs to estimate the period...
nc=combinations(num_scan,2)
djd=dblarr(nc)
da=dblarr(nc)
; ...determine optimum mean spacing of measures
j=1
for i=0,num_scan-2 do begin
	djd[i]=jd[i+j]-jd[i]
	da[i]=area[i+j]-area[i]
	if da[i] lt 0 then da[i]=da[i]+e_area
endfor
index=where(djd ne 0)
da_m=median(da[index])
limit=0.01	; Binary radius must sweep more than (limit*100)% of area
;		  between m.
j=fix(limit/(da_m/e_area)+1)
optimum=3	; Hand-tweaked, for now...
j_max=max([j,fix(e_area/da_m/optimum)])
;
; ...Obtain estimates for all allowed pairs...
djd[*]=0
da[*]=0
n=0
break=0
while j lt num_scan and not break do begin
	for i=0,num_scan-j-1 do begin
		djd[n]=jd[i+j]-jd[i]
		da[n]=area[i+j]-area[i]
		if da[n] lt 0 then da[n]=da[n]+e_area
		n=n+1
	endfor
	if j eq j_max then break=1
	j=j+1
endwhile
index=where(djd ne 0 and da ne 0,count)
da=da[index] & djd=djd[index]
o_parms[5]=median(e_area/da*djd)
;
; First improvement of period by unwrapping phases
new_da=da
for i=0,count-1 do begin
	new_da[i]=da[i]+fix(djd[i]/o_parms[5])*e_area
	period=e_area/new_da[i]*djd[i]
	if period/o_parms[5] lt 0.1 then new_da[i]=0
endfor
index=where(new_da ne 0)
period=e_area/new_da[index]*djd[index]
o_parms[5]=median(period)
;
; Second improvement by computing cummulative areas
; for i=0,count-1 do begin
;	new_da(i)=da(i)+fix(djd(i)/o_parms(5))*e_area
;	period=e_area/new_da(i)*djd(i)
;	if period/o_parms(5) lt 0.1 then new_da(i)=new_da(i)-e_area
; endfor
; cda=new_da
; cdjd=djd
; for i=0L,n_elements(new_da)-1 do cda(i)=total(new_da(0:i))
; for i=0L,n_elements(djd)-1 do cdjd(i)=total(djd(0:i))
; coeffs=poly_fit(cdjd,cda,1)
; o_parms(5)=e_area/coeffs(1)
;
; Use Kepler's second law to compute epochs for phases p
t=a/e_area*o_parms[5]
dp=abs(theta[0]-p)
index=where(dp eq min(dp))
a0=a[index] & a0=a0[0]
tjd=dblarr(num_scan)
for i=0,num_scan-1 do begin
	dp=abs(theta[i]-p)
	index=where(dp eq min(dp))
	tjd[i]=jd[0]+((jd[i]-jd[0]) mod o_parms[5]) $
		-abs(a[index]-a0)/e_area*o_parms[5]
endfor
jd0=double(median(tjd))
dp=abs(theta[0]-p)
index=where(dp eq min(dp))
t=t-t[index[0]]+jd0
;
; Find periastron and compute eccentricty
p_w=atan(e_parms[0],e_parms[1])+pi_circle
dp=abs(p_w-p)
p_index=where(dp eq min(dp)) & p_index=p_index[0]
ap=r[p_index]
o_parms[1]=1/(1+ap/sqrt(total(e_parms[0:1]^2)))
;
; Get epoch from array t
o_parms[6]=t[p_index]
;
; Compute point R with true anomaly = 90
t_90=o_parms[6]+o_parms[5]/2/pi_circle $
	*(acos(o_parms[1])-o_parms[1]*sqrt(1-o_parms[1]^2))
dt=abs((t-t_90) mod o_parms[5])
r_index=where(dt eq min(dt)) & r_index=r_index[0]
;
; Compute Thiele-Innes constants
X1=x[p_index]/(1-o_parms[1])
Y1=y[p_index]/(1-o_parms[1])
X2=x[r_index]/(1-o_parms[1]^2)
Y2=y[r_index]/(1-o_parms[1]^2)
;
; Compute argument of periastron
wpw=atan((X1-Y2)/(X2+Y1))
wmw=atan((X1+Y2)/(X2-Y1))
if (X1-Y2)*sin(wpw) lt 0 then wpw=wpw+pi_circle
if (X1+Y2)*sin(wmw) gt 0 then wmw=wmw+pi_circle
o_parms[3]=((wpw+wmw)/2) mod (2*pi_circle)
o_parms[3]=(o_parms[3]+pi_circle) mod (2*pi_circle)	; change to primary
;
; Compute argument of ascending node
o_parms[4]=(wpw-wmw)/2
if o_parms[4] lt 0 then o_parms[4]=o_parms[4]+2*pi_circle
;
; If e near 0, set w=0 and re-do epoch
if o_parms[1] lt 0.001 then begin
	o_parms[6]=o_parms[6]-o_parms[3]/2/pi_circle*o_parms[5]
	o_parms[3]=0
endif
;
; Compute inclination
o_parms[2]=atan(sqrt(-(X1+Y2)*sin(wpw)/(X1-Y2)/sin(wmw)))*2
;
; Compute semi-major axis
o_parms[0]=(X1-Y2)/sin(wpw)/(1+cos(o_parms[2]))
;
print,'__________________________________'
print,'Thiele-Innes estimates: '
print,'Semi-major axis = ',o_parms[0]
print,'Eccentricity =    ',o_parms[1]
print,'Inclination =     ',o_parms[2]*RAD
print,'Periastron =      ',o_parms[3]*RAD
print,'Ascending node =  ',o_parms[4]*RAD
print,'Period =          ',o_parms[5]
print,'Epoch =           ',o_parms[6]
print,'_______________***________________'
;
return,o_parms
end
