function timejitter,t,s,stroke
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Correct delay s (sidereal) for jitter in timestamps t.
; Return delays corresponding to nearest integer values
; of the timestamps. Corrections are applied both for
; stroke and sidereal rate.
;
timeshift=median(t mod 1)
x=double(nint(t-timeshift))+timeshift
s_new=s
;
index=where(x ne t,count)
if count gt 0 then begin
	ddt=median(abs(t[index]-x[index]))
	print,'Jitter seems to be ',ddt, $
		', including timeshift of ',timeshift,'.'
	s_new[index]=s_new[index]-ddt*stroke
	c=perifit(t,s_new,86400000,y)
	s_new[index]=s_new[index] $
	            -(y[index]-interpol(y,t,x[index]))
endif
if timeshift ne 0 then begin
	c=perifit(t,s_new,86400000,y)
	s_new=s_new $
	     -(y-interpol(y,t,double(nint(x))))
endif
;
return,s_new
;
end
