pro titleplacement,type,ds_stars,label,num_label,scale_cs=scale_cs
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; This procedure computes the parameters for the placement of items in title
; and the x- and y-axes. Must be called with type 't' first, before 'x' and 'y'!
;
common PlacementInfo,xpix_per_char,ypix_per_char, $
		     title_yoffset,title_xoffset, $
		     xtitle_xoffset,xtitle_yoffset, $
		     ytitle_xoffset,ytitle_yoffset, $
		     num_title,max_star_per_title,xpix_per_star, $
		     num_xtitle,max_xlabel_per_title,xpix_per_xlabel, $
		     num_ytitle,max_ylabel_per_title,xpix_per_ylabel
;
if not keyword_set(scale_cs) then scale_cs=1.0
;
case type of
	't':begin
;	    Calculate title placement variables
	    num_star=n_elements(ds_stars)
	    xpix_per_unit_char=!d.x_ch_size
	    xpix_per_char=fix(xpix_per_unit_char*!p.charsize/scale_cs)
	    ypix_per_unit_char=!d.y_ch_size
	    ypix_per_char=fix(ypix_per_unit_char*!p.charsize/scale_cs)
	    xpix_per_star=(max(strlen(ds_stars))+1)*xpix_per_char
	    max_star_per_title=!d.x_vsize/xpix_per_star
	    num_title=fix(float(num_star)/max_star_per_title+1)
	    title_yoffset=!d.y_vsize-(indgen(num_title)+1)*(ypix_per_char)
	    num_star_per_title=intarr(num_title)+max_star_per_title
	    if num_title ge 2 then begin
		sub_total=total(num_star_per_title[0:num_title-2])
		num_star_per_title[num_title-1]=num_star-sub_total
	    endif else num_star_per_title[0]=num_star
	    title_xoffset=intarr(num_title)
	    for i=0,num_title-1 do title_xoffset[i]= $
		(!d.x_vsize-num_star_per_title[i]*xpix_per_star)/2
	    end
	'x':begin
;	    Calculate xtitle placement variables
	    xpix_per_xlabel=(strlen(label)+1)*xpix_per_char
	    max_xlabel_per_title=!d.x_vsize/xpix_per_xlabel
	    num_xtitle=fix(float(num_label)/max_xlabel_per_title+1)
	    xtitle_yoffset= $
		(num_xtitle-indgen(num_xtitle))*(ypix_per_char)
	    num_xlabel_per_title= $
		intarr(num_xtitle)+max_xlabel_per_title
	    if num_xtitle ge 2 then begin
			sub_total= $
			   total(num_xlabel_per_title[0:num_xtitle-2])
			num_xlabel_per_title[num_xtitle-1]= $
			   num_label-sub_total
	    endif else num_xlabel_per_title[0]=num_label
	    xtitle_xoffset=intarr(num_xtitle)
	    for i=0,num_xtitle-1 do xtitle_xoffset[i]= $
		    (!d.x_vsize-num_xlabel_per_title[i]*xpix_per_xlabel)/2
	    end
	'y':begin
;	    Calculate ytitle placement variables
	    xpix_per_ylabel=(strlen(label)+1)*xpix_per_char
	    max_ylabel_per_title= $
		(!d.y_vsize-ypix_per_char*(num_title+num_xtitle)) $
				 /ypix_per_char
	    num_ytitle=fix(float(num_label)/max_ylabel_per_title+1)
	    ytitle_xoffset=indgen(num_ytitle)*xpix_per_ylabel
	    num_ylabel_per_title= $
			intarr(num_ytitle)+max_ylabel_per_title
	    if num_ytitle ge 2 then begin
			sub_total= $
			   total(num_ylabel_per_title[0:num_ytitle-2])
			num_ylabel_per_title[num_ytitle-1]= $
			   num_label-sub_total
	    endif else num_ylabel_per_title[0]=num_label
	    ytitle_yoffset=intarr(num_ytitle)
	    for i=0,num_ytitle-1 do ytitle_yoffset[i]= $
		(!d.y_vsize-(num_ylabel_per_title[i]+num_title+num_xtitle) $
				*ypix_per_char)/2+num_xtitle*ypix_per_char
	    end
endcase
;
end
