pro tkpm,ch
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Plots contours of the PEARL image computed for channel ch.
;
common PearlData,ov,ow,uc,vc,cv,mv,si,bi,ci,wl,bw,fl,db,cb,dm,rm,cm,cc,rt,rg,rf
;
if ch eq 0 then begin
	tkfm
	return
endif
map=pearlmap(wl[ch-1]*1e-9,channel=ch)
map=map/max(map)*max(cm.maps[0].map+cc.maps[0].map)+rm.maps[0].map
;
rad2mas=180l*3600l*1000l/!pi
;
plevels=[0.05,0.1,0.2,0.5,1,2,5,10,20,50,80]
index=where(plevels gt abs(min(map)/max(map))*100)
if index[0] gt 0 then index=[index[0]-1,index]
if index[0] eq -1 then index=[9]
plevels=plevels[index]
nlevels=[-plevels[0]]
;
levels=[nlevels,plevels]
levels_label=''
x=-unique(cm.x)*rad2mas
y=+unique(cm.y)*rad2mas
;
for i=0,n_elements(levels)-1 do begin
	if abs(levels[i]) lt 1 then $
		if levels[i] lt 0 then format='(f5.1)' else format='(f4.1)'
	if abs(levels[i]) ge 1 then $
		if levels[i] lt 0 then format='(i3)' else format='(i2)'
	if abs(levels[i]) ge 10 then $
		if levels[i] lt 0 then format='(i4)' else format='(i3)'
	levels_label=levels_label+string(levels[i],format=format)
endfor
;
!p.multi=0
!x.range=0
!y.range=0
;
contour,map,x,y,levels=plevels*max(map)/100,xstyle=1,ystyle=1, $
	xtitle='Contours: '+levels_label+' % of peak',ytitle='[mas]', $
	xrange=[max(x),min(x)]
contour,map,x,y,levels=nlevels*max(map)/100,c_linestyle=1,/overplot
;
end
