pro topoplanet,times,planets,ra_app,dec_app,distance
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Calculate topocentric apparent planet positions. Procedure calls C function
; tpplanet for calls to topoplanet in the NOVAS C-library of astrometry
; subroutines (Kaplan, G.H. et al. 1989, AJ, 97 1197).
; Input variables can be arrays to speed up processing.
;
; Format of date (string): YYYY-MM-DD
; times (double): seconds since 0 UTC.
; planets (long): star names as in startable.
; Mercury: 1,..., Pluto: 9, Sun: 10, Moon:11
;
; These are the units (type double):
; ra=Right Ascension in hours plus fraction thereof
; dec=Declination in degrees plus fractions thereof
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
; Check input
num_times=n_elements(times)
num_planets=n_elements(planets)
if num_times ne num_planets then begin
	print,'***Error(TOPOPLANET): times and planets have different lengths!'
	return
endif
;
ra_app=dblarr(num_times)
dec_app=dblarr(num_times)
distance=dblarr(num_times)
;
times=double(times)
planets=long(planets)
;
; UTC is in seconds. Remember, CONSTRICTOR point times are in milliseconds,
; averaged scan times are in seconds since 0 UT!
UTC=times
parsedate,Date,y,m,d
tjd=(UTC+GeoParms.TAI_UTC+GeoParms.TDT_TAI)/86400+julian(y,m,d)
;
TDT_UT1=UTC+GeoParms.TAI_UTC+GeoParms.TDT_TAI-utc2ut1(UTC)
;
loc=dblarr(3)
loc[0]=GeoParms.Longitude
loc[1]=GeoParms.Latitude
loc[2]=GeoParms.Altitude
;
status=linknload(!external_lib,'tpplanet',num_times,planets,tjd,TDT_UT1, $
		loc,ra_app,dec_app,distance)
if status ne 0 then $
	print,'***Error(TOPOPLANET): tpplanet returns code ',status,'!'
;
if num_times eq 1 then begin
	ra_app=ra_app[0]
	dec_app=dec_app[0]
	distance=distance[0]
endif
;
end
