function trackdelay,v,l,f,p,t,gindex,wrap=wrap
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute the corrected group delay and return the corrected visibility
; phases. Think of the corrected group delay as the residual delay
; between the actual delay line tracking and an ideal delay line.
; The ideal delay line here is one using group delay tracking such that
; the mean white light fringe phase is close to zero.
;
; If parameter gindex is passed (to be set on return), use new algorithm
; to flag low-SNR groupdelays and smooth/interpolate those samples.
;
; v=complex visibility
; l=array of wavelengths [m]
; f=residual laser delay [m]
; t=time [s]
;
if n_elements(wrap) eq 0 then wrap=0 else wrap=wrap gt 0
;
p2d=lambdawhite(v,l)/(2*!pi)
;
d=gitter(121,-12e-6)
numav=10	; Average this many power spectra for group delay
;
if n_params() eq 6 then begin
	g=groupdelay(abs(visdft(v,l,d)),l,d,gindex)
	g=gsmooth(t[where(gindex gt 0)],g[where(gindex gt 0)],numav*0.001,t)
endif else begin
; 	Subtract any delay "vibrations" before averaging the power spectrum
;	s=f-smooth(f,100,/edge_truncate)
	s=f-median(f,100)
	g=s+groupdelay(box(abs(visdft(visrotate(v,l,s),l,d)),numav,1),l,d,index)
endelse
; f-g is the actual fringe position in case the delay line is off the fringe
g=g+phaseshift(median(f,100)-g,l)*p2d
p=cphase(total(visrotate(v,l,g),1))
c=phasescan(t,p,wrap=wrap)
g=g-c*p2d
p=cphase(total(visrotate(v,l,g),1))
;
return,g
;
end
