function trackdelays,baseline,beam,scanfile,channels=channels,gindex=gindex
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute and return tracking delays for specified baseline.
; Must have used get_rawdata first!
; If scanfile defined, compute and concatenate for all sub-scans.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
;
if n_elements(scanfile) ne 0 then scanfiles=file_search(scanfile+'.??') $
			     else scanfiles=''
;
if n_elements(beam) eq 0 then beam=OutputBeam $
			 else if n_elements(scanfile) eq 0 $
			 	then get_bincounts,beam
ob=beam-1
bl=baseline-1
if n_elements(channels) eq 0 then $
	channels=channelindex[genconfig.spectrometerid[ob]]
ch=channels-1
if keyword_set(gindex) then classic=0 else classic=1
;
l=genconfig.wavelength[ch,ob]
;
phases=fltarr(n_elements(fdlstamp(scan=n_elements(scanfile))))
delays=phases
gindex=fix(phases*0)
;
for i=0,n_elements(scanfiles)-1 do begin
	if strlen(scanfiles[i]) gt 0 then begin
		hds_open,scanfiles[i]
		get_bincounts,beam
		hds_close
	endif
	v=fringevis(bincounts[*,ch,*],genconfig.fringemod[bl,ob])
	f=fdldelay(genconfig.baselineid[bl,ob],scan=0)
	t=fdlstamp()/1000.d0 & t=t-t[0]
	if classic then begin
			delays[raw0:rawn]=trackdelay(v,l,f,p,t)
			phases[raw0:rawn]=p
		   endif else begin
			delays[raw0:rawn]=trackdelay(v,l,f,p,t,index)
			phases[raw0:rawn]=p
			gindex[raw0:rawn]=index
		   endelse
endfor
;
return,delays
;
end
