function trackindex
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; For all time stamps (i.e. scans), evaluate which baselines and triples have
; valid data and mark the participating stations.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
tindex=intarr(genconfig.numsid,n_elements(scans))
r=strarr(n_elements(scans))
FOR i=0,n_elements(scans)-1 DO BEGIN
for ob=0,genconfig.numoutbeam-1 do begin
	index=where(reform(total(scans[i].vissqcerr(ob,*,*) ge 0,2) gt 0) eq 1)
	if index[0] ne -1 then begin
	jndex=whereequal(genconfig.stationid, $
		nameparse(strjoin(genconfig.baselineid[index,ob],'-'),'-'))
	if jndex[0] ne -1 then tindex[jndex,i]=1
	endif
endfor
r[i]=strjoin(string(tindex[*,i],format='(i1)'))
tindex=intarr(genconfig.numsid,n_elements(scans))
for tr=0,genconfig.numtriple-1 do begin
	index=where(reform(total(scans[i].tripleampcerr(tr,*) ge 0,2) gt 0) eq 1)
	if index[0] ne -1 then begin
	jndex=whereequal(genconfig.stationid, $
	nameparse(strjoin(genconfig.baselineid[genconfig.triplebase[*,tr], $
					       genconfig.triplebeam[*,tr]], $
						'-'),'-'))
	if jndex[0] ne -1 then tindex[jndex,i]=1
	endif
endfor
r[i]=r[i]+', '+strjoin(string(tindex[*,i],format='(i1)'))
ENDFOR
;
return,r
;
end
