function tripleconfig,tr
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Returns the baseline factors (+/-1) for each triple in the data.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
fBaseMatrix=intarr(GenConfig.NumSid,3)
fBaseFactor=fltarr(3)+1
;
for l=0,2 do begin
	ob=GenConfig.TripleBeam[l,tr-1]
	bl=GenConfig.TripleBase[l,tr-1]
	j1=where(GenConfig.StationId eq $
  	strmid(GenConfig.BaselineId[bl,ob],0,3))
	j2=where(GenConfig.StationId eq $
  	strmid(GenConfig.BaselineId[bl,ob],4,3))
	fBaseMatrix[j1,l]=+1
	fBaseMatrix[j2,l]=-1
	if l gt 0 then fBaseFactor[l]=-total(fBaseMatrix[*,0]*fBaseMatrix[*,l])
endfor
;
return,fBaseFactor
;
end
