pro tripleproduct
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Add to or remove a triple product from the pointdata. The information on the
; three baselines selected is contained in triple(TripleInfo). The information
; on which channels will be combined is contained in channels(TripleInfo)
; The triple product is the complex product of ComplexVis on three baselines.
;
common TripleInfo,triple,channels,action
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
;
; Check presence of GenConfig and PointData
if checkdata([8,11]) ne 0 then return
;
; Check validity of channel selection
index=where(channels ge 0,count)
if count mod 3 ne 0 then begin
	print,'***Error(TRIPLEPRODUCT): invalid channel selection!'
	return
endif
count_c=count/3
chans=channels[0:count_c-1,*]
;
; Check validity of triple and channel selection
index=where(triple lt 0,flag1)
index=where(chans lt 0,flag2)
flag=flag1+flag2
if flag eq 0 then begin
for i=0,2 do begin
	if triple[i,0] ge GenConfig.NumOutBeam then flag=1 else begin
	if triple[i,1] ge GenConfig.NumBaseline[triple[i,0]] then flag=1
	if max(chans[*,i]) ge GenConfig.NumSpecChan[triple[i,0]] then flag=1
	endelse
endfor
endif
if flag ne 0 then begin
	print,'***Error(TRIPLEPRODUCT): invalid selection!'
	return
endif
;
MS=max(GenConfig.NumSpecChan)
MP=n_elements(PointTime)
;
IF action eq 'Add' then BEGIN
;
GenConfig.NumTriple=GenConfig.NumTriple+1
;
; Extend and allocate arrays
; (Note that a minimum of one triple is always allocated)
if GenConfig.NumTriple gt 1 then begin
        CT=fltarr(GenConfig.NumTriple,2,MS,MP,/nozero)
        CTE=fltarr(GenConfig.NumTriple,2,MS,MP,/nozero)
	CT[0:GenConfig.NumTriple-2,*,*,*]=ComplTriple
	CTE[0:GenConfig.NumTriple-2,*,*,*]=ComplTripleErr
	ComplTriple=CT
	ComplTripleErr=CTE
        TripleAmp=fltarr(GenConfig.NumTriple,MS,MP,/nozero)
        TripleAmpErr=fltarr(GenConfig.NumTriple,MS,MP,/nozero)
        TriplePhase=fltarr(GenConfig.NumTriple,MS,MP,/nozero)
        TriplePhaseErr=fltarr(GenConfig.NumTriple,MS,MP,/nozero)
endif
;
; Update GenConfig
GenConfig.TripleBeam[*,GenConfig.NumTriple-1]=triple[*,0]
GenConfig.TripleBase[*,GenConfig.NumTriple-1]=triple[*,1]
GenConfig.TripleChan[0:count_c-1,*,GenConfig.NumTriple-1]=chans
GenConfig.TripleNumChan[GenConfig.NumTriple-1]=count_c
;
; Compute complex triple product
ComplexVis1=complex(ComplexVis[triple[0,0],0,chans[*,0],triple[0,1],*], $
		    ComplexVis[triple[0,0],1,chans[*,0],triple[0,1],*])
ComplexVis2=complex(ComplexVis[triple[1,0],0,chans[*,1],triple[1,1],*], $
		    ComplexVis[triple[1,0],1,chans[*,1],triple[1,1],*])
ComplexVis3=complex(ComplexVis[triple[2,0],0,chans[*,2],triple[2,1],*], $
		    ComplexVis[triple[2,0],1,chans[*,2],triple[2,1],*])
ComplexTriple=ComplexVis1*ComplexVis2*ComplexVis3
ComplTriple[GenConfig.NumTriple-1,0,0:count_c-1,*]=float(ComplexTriple)
ComplTriple[GenConfig.NumTriple-1,1,0:count_c-1,*]=imaginary(ComplexTriple)
;
; Compute error of complex triple product
ComplexVisErr1= $
	complex(ComplexVisErr[triple[0,0],0,chans[*,0],triple[0,1],*], $
		ComplexVisErr[triple[0,0],1,chans[*,0],triple[0,1],*])
ComplexVisErr2= $
	complex(ComplexVisErr[triple[1,0],0,chans[*,1],triple[1,1],*], $
		ComplexVisErr[triple[1,0],1,chans[*,1],triple[1,1],*])
ComplexVisErr3= $
	complex(ComplexVisErr[triple[2,0],0,chans[*,2],triple[2,1],*], $
		ComplexVisErr[triple[2,0],1,chans[*,2],triple[2,1],*])
ComplexTripleErr=sqrt((ComplexVis2*ComplexVis3*ComplexVisErr1)^2+ $
		      (ComplexVis1*ComplexVis3*ComplexVisErr2)^2+ $
	  	      (ComplexVis1*ComplexVis2*ComplexVisErr3)^2)
ComplTripleErr[GenConfig.NumTriple-1,0,0:count_c-1,*]= $
						float(ComplexTripleErr)
ComplTripleErr[GenConfig.NumTriple-1,1,0:count_c-1,*]= $
						imaginary(ComplexTripleErr)
;
; Compute amplitude and phase of complex triple product
set_tripleampphase
print,'Triple added.'
;
ENDIF ELSE IF action eq 'Delete' then BEGIN
;
if GenConfig.NumTriple eq 0 then begin
	print,'Warning(TRIPLEPRODUCT): no triples found.'
	return
endif
;
removed=0
repeat begin
i=0
repeat begin
	has=0
	for j=0,2 do begin
		hit=0
		for k=0,2 do begin
			obs=[GenConfig.TripleBeam[k,i], $
		     	     GenConfig.TripleBase[k,i]]
			if total(abs(obs-triple[j,*])) eq 0 then hit=hit+1
		endfor
		if hit ne 0 then has=has+1
	endfor
	i=i+1
endrep until has eq 3 or i eq GenConfig.NumTriple
if has eq 3 then begin
	i=i-1
	GenConfig.NumTriple=GenConfig.NumTriple-1
	removed=removed+1
	if GenConfig.NumTriple gt 0 then begin
		GenConfig.TripleBeam[*,i:GenConfig.NumTriple-1]= $
			GenConfig.TripleBeam[*,i+1:GenConfig.NumTriple]
		GenConfig.TripleBase[*,i:GenConfig.NumTriple-1]= $
			GenConfig.TripleBase[*,i+1:GenConfig.NumTriple]
		GenConfig.TripleChan[*,*,i:GenConfig.NumTriple-1]= $
			GenConfig.TripleChan[*,*,i+1:GenConfig.NumTriple]
		GenConfig.TripleNumChan[i:GenConfig.NumTriple-1]= $
			GenConfig.TripleNumChan[i+1:GenConfig.NumTriple]
		CT=fltarr(GenConfig.NumTriple,2,MS,MP,/nozero)
		if i gt 0 then CT[0:i-1,*,*,*]=ComplTriple[0:i-1,*,*,*]
		CT[i:GenConfig.NumTriple-1,*,*,*]= $
			ComplTriple[i+1:GenConfig.NumTriple,*,*,*]
		ComplTriple=CT
		CTE=fltarr(GenConfig.NumTriple,2,MS,MP,/nozero)
		if i gt 0 then CTE[0:i-1,*,*,*]=ComplTripleErr[0:i-1,*,*,*]
		CTE[i:GenConfig.NumTriple-1,*,*,*]= $
			ComplTripleErr[i+1:GenConfig.NumTriple,*,*,*]
		ComplTripleErr=CTE
		TripleAmp=fltarr(GenConfig.NumTriple,MS,MP,/nozero)
		TripleAmpErr=fltarr(GenConfig.NumTriple,MS,MP,/nozero)
		TriplePhase=fltarr(GenConfig.NumTriple,MS,MP,/nozero)
		TriplePhaseErr=fltarr(GenConfig.NumTriple,MS,MP,/nozero)
		set_tripleampphase
	endif
	print,'Triple removed.'
endif
endrep until has lt 3 or GenConfig.NumTriple eq 0
if removed eq 0 then print,'Warning(TRIPLEPRODUCT): triple not found.'
;
ENDIF ELSE print,'***Error(TRIPLEPRODUCT): unknown action: ',action,'!'
;
end
