pro trucolor
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; As of October 24, 2008, OYSTER assumes to be running on 24+ bit displays.
; Therfore, we decompose 24-bit color indices into the three 8-bit
; RGB indices. TrueColor means non-translated indices, DirectColor
; means that the 8-bit indices can also be translated with a table to
; the final value.
;
; Some comments on color in IDL: to use color tables (non-decomposed
; mode), load RGB indices with TVLCT, e.g. TVLCT, 53, 156, 83, 100.
; Pre-defined color tables are loaded using LOADCT.
;
if !d.name eq 'X' then begin
	if !idl then begin
;		On MacOS, the following call to device cause an exception
		!except=0		; To ignore the exception
		help,/device,output=r
		result=check_math()	; Reset the exception status
		!except=1		; Set back to default
		index=where(strpos(r,'Display') ge 0)
		r=r[index]
		index=where(strpos(r,'Depth') ge 0)
		r=r[index]
		words=nameparse(r[0])
		bit_depth=long(words[3])
		device,true_color=bit_depth,/decompose
	endif
	loadct,0,/silent
	!p.color=tci(1)
endif
;
end
