function true2app,mjd,o_parms,rho,theta,ra,dec,z
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute and return right ascension and declination offset of secondary
; relative to primary  for given epoch (mod. JD!) and orbital elements.
; Originally written by J. Armstrong, based on W. Heintz, Double Stars, p. 34
;
; Note: The RV of whichever component is in the vicinity of the ascending
; node is positive (away from observer) with respect to that of the other
; component, or wrt its own RV in other parts of the orbit.
;
; Note: if the inclination is < 90, the orbit is prograde, i.e. the
; PA increases. If i>90, the orbit is retrograde, i.e. PA decreases.
;
; Note: the periastron angle is the one of the primary. It is counted from
; the ascending node in the direction of motion of that component.
; It is changed from the primary to the secondary by adding 180 deg as the
; formulae from Heintz and Green are all assuming the secondary elements.
;
; The following statement was true until Version 6.05:
; Currently, the angle of the ascending node is 180 degrees off.
; Therefore, currently the primary is moving away from the
; observer if the secondary is at the "ascending" node.
;
; Position angle verifications: (this paragraph started in Nov 2008)
; Gamma Per: A-comp. rel. to G-comp. PA=244 deg (most of the time)
; This is according to Pourbaix 1999, and Prieur et al. 2002 (Speckle)
; and Couteau (1987, but he mentions that it is in the 4th quadrant?).
; However, the McAlister measurements give the PA as 60 deg, why?
; Mason et al. 2001 even lists PA=64 deg! Zavala confirmed 244 deg is
; consistent with NPOI observations reduced with OYSTER.
;
; Another check star is 1 Geminorum, which was measured by Hipparcos
; at rho=185 mas, theta=227 deg.
;
; Theta is returned in [rad].
;
; Hint: if you happen to get a negative eccentricity, add 180 to the
; periastron angle and half a period to the epoch to change the sign.
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common AstroConstants,m_sun,r_sun,a_unit,s_year
;
a=o_parms[0]
e=o_parms[1]
i=o_parms[2]
w=o_parms[3]
s=o_parms[4]
if n_elements(dec) ne 0 $
	then n=precess_pa(o_parms[5],jd2jy(mjd+2440000L),ra,dec,1) $
	else n=o_parms[5]
w=(w+!pi) mod (2*!pi)	; change from primary to secondary definition
;
p=o_parms[6]
t=o_parms[7]
;
M_anom=2*pi_circle*((mjd-t) mod p)/p
E_anom=M_anom+e*sin(M_anom)+e^2/2*sin(2*M_anom)
for k=0,4 do E_anom=E_anom+(M_anom-E_anom+e*sin(E_anom))/(1-e*cos(E_anom))
T_anom=2*atan(sqrt((1+e)/(1-e))*sin(E_anom/2),cos(E_anom/2))
;
; Apply apsidal motion
ws=w+(mjd-t)/s_year*s
;
alpha=T_anom+ws
;
; From R.M. Green, Spherical Astronomy, p. 470
r=((a*(1-e^2))/(1+e*cos(T_anom)))
x=r*(cos(alpha)*sin(n)+sin(alpha)*cos(n)*cos(i))
y=r*(cos(alpha)*cos(n)-sin(alpha)*sin(n)*cos(i))
z=r*sin(alpha)*sin(i)
;
; From Heintz (results in same [x,y] values)
theta=atan(sin(alpha)*cos(i),cos(alpha))+n
rho=((a*(1-e^2))/(1+e*cos(T_anom)))*sqrt(cos(alpha)^2+sin(alpha)^2*cos(i)^2)
index=where(rho lt 0,count)
if count gt 0 then begin
	theta[index]=theta[index]+pi_circle
	rho[index]=abs(rho[index])
endif
index=where(theta lt 0,count)
if count gt 0 then theta[index]=theta[index]+2*pi_circle
;
; return,[[rho*sin(theta)],[rho*cos(theta)]]
return,[[x],[y]]
;
end
