function true2vel,jd,o_parms
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Note that if radial velocities are available for the primary only,
; one should fit M2 only.
;
; Argument of periastron (w) taken to be of the primary component.
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common AstroConstants,m_sun,r_sun,a_unit,s_year
;
e=o_parms[0]
i=o_parms[1]
w=o_parms[2]
s=o_parms[3]	; apsidal motion
p=o_parms[4]	; period
t=o_parms[5]	; epoch
m1=o_parms[6]
m2=o_parms[7]
;
M_anom=2*pi_circle*((jd-t) mod p)/p
E_anom=M_anom+e*sin(M_anom)+e^2/2*sin(2*M_anom)
for k=0,4 do E_anom=E_anom+(M_anom-E_anom+e*sin(E_anom))/(1-e*cos(E_anom))
T_anom=2*atan(sqrt((1+e)/(1-e))*sin(E_anom/2),cos(E_anom/2))
;
; K1, K2 [km/s]
p=p/s_year
k1=2*pi_circle*sin(i)/sqrt(1-e^2)*p^(-1.0/3.0)*m2*(m1+m2)^(-2.0/3.0) $
	*(a_unit/s_year)/86400000L
k2=k1*(m1/m2)
;
; Apply apsidal motion
ws=w+(jd-t)/s_year*s
v1=+k1*(cos(T_anom+ws)+e*cos(ws))
v2=-k2*(cos(T_anom+ws)+e*cos(ws))
return,[[v1],[v2]]
;
end
