pro uncal
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Removes calibration for a given data selection. All scans.
;
common SolInfo,cal_stars,cal_options,indicators,sel_indct,sel_funcn
common CalInfo,cal_entries
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common Tables,ScanTable,BGTable,StationTable
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
; Note that we use the 'y'-stream dataselection!
flag=set_starsel()
if set_indexsel('y') ne 0 then begin
	print,'***Error(RESETCAL): invalid data selection!'
	return
endif
set_streamsel,'y',item,ds_ib,ds_ob,ds_tr,ds_ch,ds_bl,ds_pt
;
num_channel=n_elements(ds_ch)
num_baseline=n_elements(ds_bl)
if cal_options.v gt 0 then num_baseline=1
;
for ic=0,num_channel-1 do begin
for ib=0,num_baseline-1 do begin
	channel=ds_ch[ic]
	baseline=ds_bl[ib]
	if cal_options.v eq 1 then begin
		scans[*].TripleAmpC(ds_tr,channel)= $
			scans[*].TripleAmp(ds_tr,channel)
		scans[*].TripleAmpCErr(ds_tr,channel)= $
			scans[*].TripleAmpErr(ds_tr,channel)
		scans[*].TripleAmpEC(ds_tr,channel)= $
			scans[*].TripleAmpE(ds_tr,channel)
		scans[*].TripleAmpECErr(ds_tr,channel)= $
			scans[*].TripleAmpEErr(ds_tr,channel)
		entry_index=where((cal_entries.variable eq cal_options.v) and $
		    	(cal_entries.triple eq ds_tr) and $
		    	(cal_entries.channel eq channel),entry_count)
	endif else if cal_options.v eq 2 then begin
		scans[*].TriplePhaseC(ds_tr,channel)= $
			scans[*].TriplePhase(ds_tr,channel)
		scans[*].TriplePhaseCErr(ds_tr,channel)= $
			scans[*].TriplePhaseErr(ds_tr,channel)
		entry_index=where((cal_entries.variable eq cal_options.v) and $
		    	(cal_entries.triple eq ds_tr) and $
		    	(cal_entries.channel eq channel),entry_count)
	endif else begin
		scans[*].VisSqC(ds_ob,channel,baseline)= $
			scans[*].VisSq(ds_ob,channel,baseline)
		scans[*].VisSqCErr(ds_ob,channel,baseline)= $
			scans[*].VisSqErr(ds_ob,channel,baseline)
		scans[*].VisSqEC(ds_ob,channel,baseline)= $
			scans[*].VisSqE(ds_ob,channel,baseline)
		scans[*].VisSqECErr(ds_ob,channel,baseline)= $
			scans[*].VisSqEErr(ds_ob,channel,baseline)
		entry_index=where((cal_entries.variable eq cal_options.v) and $
		    	(cal_entries.outbeam eq ds_ob) and $
		    	(cal_entries.baseline eq baseline) and $
		    	(cal_entries.channel eq channel),entry_count)
	endelse
	index=intarr(n_elements(cal_entries))
	if entry_count gt 0 then index[entry_index]=-1
	entry_index=where(index ne -1,entry_count)
	if entry_count gt 0 then set_calentries,cal_entries[entry_index]
endfor
endfor
print,'Calibration cleared.'
;
end
