function unique_station_config,baselineids_in
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Based on an empirical algorithm, compute a shorter station ID string which is
; (hopefully) unique given any longer input string of baseline IDs.
;
; Example: 18 Baselines, 9 Stations (Imaging Beauty Contest 2020)
; AA0 AB2
; AA0     AD0
; AA0         AC1
;     AB2 AD0
;     AB2     AC1
;         AD0 AC1
; AA0             AG1
; AA0                 AJ2
; AA0                     AJ3
;                 AG1 AJ2
;                 AG1     AJ3
;                     AJ2 AJ3
;                             AK0 AG2
;        -AD0                 AK0     AD0
;                        -AJ3 AK0         AJ3
;        -AD0                     AG2 AD0
;                        -AJ3     AG2     AJ3
;        -AD0             AJ3         AD0
;  0   1   2   3   4   5   6   7   8   9   10
; ==>
; Unique station ID string?:
; AA0 AB2 AD0 AC1 AG1 AJ2 AJ3 AK0 AG2 AD0 AJ3
;
; UT3 UT4
;         UT1 UT2
;-UT3         UT2 UT3
;    -UT4     UT2     UT4
;-UT3     UT1     UT3
;    -UT4 UT1         UT4
;
; Another example:
; actual:  AC1-AD0 AB2-AA0 AA0-AC1 AA0-AD0 AB2-AC1 AB2-AD0
; unique:  AA0-AC1 AA0-AD0 AB2-AA0 AB2-AC1 AB2-AD0 AC1-AD0
;MATISSE_L_AA0-AC1-AD0-AB2+AC1+AD0
; actual:  AD0-AC1 AB2-AA0 AA0-AD0 AA0-AC1 AB2-AD0 AB2-AC1
; unique:  AA0-AC1 AA0-AD0 AB2-AA0 AB2-AC1 AB2-AD0 AD0-AC1
;MATISSE_L_AA0-AC1-AD0-AB2+AC1+AD0
; actual:  AC1-AD0 AA0-AB2 AB2-AC1 AB2-AD0 AA0-AC1 AA0-AD0
;MATISSE_L_AA0-AB2-AC1-AD0
; actual:  AD0-AC1 AA0-AB2 AB2-AD0 AB2-AC1 AA0-AD0 AA0-AC1
;MATISSE_L_AA0-AB2-AC1-AD0+AC1
;
; If we re-order, the result will be more compact
baselineids=unique(baselineids_in)
;
for i=0,n_elements(baselineids)-1 do begin
	sij=nameparse(baselineids[i],['-','_'])
	if i eq 0 then begin
		stationids=sij
		signs='-'
	endif else begin
		j=where(stationids eq sij[0],count)
		if count eq 0 then begin	; station not in list yet
			stationids=[stationids,sij[0]]
			signs=[signs,'-']
		endif else j=j[0]
		k=where(stationids eq sij[1],count)
		if count eq 0 then begin	; station not in list yet
			stationids=[stationids,sij[1]]
			signs=[signs,'-']
		endif
;		n=n_elements(k)
;		if k(0) ge 0 and j(0) ge 0 and k(n-1) lt j(0) then begin
;			stationids=[stationids,sij(1)]
;			signs=[signs,'+']
;		endif
;		To better handle "Another example" (see above)
		j=where(stationids eq sij[0])
		k=where(stationids eq sij[1])
		if k[0] lt j[0] then begin
			sij=nameparse(breve(baselineids[i]),['-','_'])
			stationids=[stationids,sij[1]]
			signs=[signs,'+']
		endif
	endelse
endfor
;
; return,strjoin(stationids(0:n-2)+signs)+stationids(n-1)
;
; Reduce to minimum unique
n=n_elements(stationids)
usc='-'+strjoin(stationids[0:n-2]+'|'+signs)+stationids[n-1]
s=strsplit(usc,'|',/extract)
s=strjoin(s[uniq(s)])
return,strmid(s,1,strlen(s)-1)
;
end
