pro unwrapphase
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Unwraps phase in VisPhase as a function of wavelength.
; Calls a C-program for fast execution.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
;
if checkdata([8,11]) ne 0 then return
;
; Actual array dimensions
NOB=n_elements(VisPhase[*,0,0,0])
NCH=n_elements(VisPhase[0,*,0,0])
NBL=n_elements(VisPhase[0,0,*,0])
numbaseline=GenConfig.NumBaseline
numchannel =GenConfig.NumSpecChan
numpoint=n_elements(VisPhase[0,0,0,*])
;
status=linknload(!external_lib,'unwrapphase',VisPhase,VisPhaseErr, $
	NOB,NBL,NCH,numbaseline,numchannel,numpoint)
if status eq 0 then print,'Unwrapping complete.' $
	else print,'***Error(UNWRAP): UNWRAP bombs!'
;
end
