pro unwraptriple
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Unwraps phase in TriplePhase as a function of wavelength.
; Calls a C-program for fast execution. PointData only.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
;
if checkdata([8,11]) ne 0 then return
;
NTr=GenConfig.NumTriple
NCh=GenConfig.TripleNumChan
MTr=n_elements(TriplePhase[*,0,0])
MCh=max(GenConfig.NumSpecChan)
numpoint=n_elements(TriplePhase[0,0,*])
;
status=linknload(!external_lib,'unwraptriple',TriplePhase,TriplePhaseErr, $
	NTr,NCh,MTr,MCh,numpoint)
if status eq 0 then print,'Unwrapping complete.' $
	else print,'***Error(UNWRAPTRIPLE): UNWRAPTRIPLE bombs!'
;
end
