pro update_cat,starids
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Update a secondary catalog file (only one at a time is allowed) with
; information found in the startable for the specified starids. If a starid
; is not found in the catalog, it is added, otherwise it is updated.
; If starids are not defined, the entire startable is used for the update.
;
; Note: the catalog, e.g. USR, is extracted from the first three letters
; of the StarID, and therefore the only valid catalogs for this function
; are currently: USR, HDN, and CAL.
;
common StarBase,StarTable,Notes
;
allowed_cats=['USR','HDN','CAL']
;
if n_elements(startable) eq 0 then begin
	print,'***Error(UPDATE_CAT): startable does not exist!'
	return
endif
if n_elements(starids) eq 0 then starids=startable.starid
catids=unique(strmid(starids,0,3))
if n_elements(catids) gt 1 then begin
	print,'***Error(UPDATE_CAT): cannot update more than one catalog!'
	return
endif
catid=catids[0]
index=where(allowed_cats eq catid,n)
if n ne 1 then begin
	print,'***Error(UPDATE_CAT): catalog not allowed: '+catid
	return
endif
;
table0=startable				; startable with new star IDs
get_cat,catid					; load requested catalog
startable=merge_startable(startable,table0)	; merge the 2 tables
;
; In case of binaries with composite spectral classes, attempt to split them
spec_parse
;
; Save copy of current StarTable (xdr format)
f_stub=!catalogs_dir+strlowcase(catid)+'/'+catid
file_copy,f_stub+'.xdr',f_stub+'_'+jd2date(systime(/julian))+'.xdr',/overwrite
;
; Save new StarTable
save,startable,filename=f_stub+'.xdr'
;
print,'Catalog '+catid+' updated. Number of entries:' $
	+string(n_elements(startable))
print,'Backup of previous version made.'
;
end
