pro update_eop,year
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; This routine will download Earth orientation data provided by the IERS.
; The http address is composed of a static part and a volume string, e.g.:
; https://datacenter.iers.org/data/6/bulletina-xxxiii-025.txt where "025"
; is the week number (this routine will cycle through all weeks until the
; current one. The output is written to mark.upd and needs to appended to
; mark3.dat.
;
; This routine was used temporarily instead of the update script in folder
; "usno". As of 2023, the latter has been updated and works again.
;
; Roman numerals
;
;  I            1
;  IV           4
;  V            5
;  IX           9
;  X            10
;  XL           40
;  L            50
;  XC           90
;  C            100
;  CD           400
;  D            500
;  CM           900
;  M            1000
;
years=[2019,2020,2021,2022,2023,2024,2025]
volumes=['xxxii','xxxiii','xxxiv','xxxv','xxxvi','xxxvii','xxxviii']
;
if n_elements(year) eq 0 then begin
	words=nameparse(today(),'_')
	year=words[n_elements(words)-1]
endif
volume=volumes[where(years eq year)] & volume=volume[0]
;
jd_jan1=julian(year,1,1)
jd_today=today(/jd)
;
link='https://datacenter.iers.org/data/6/'
;
cd,!oyster_dir+'/usno',current=old_dir
;
openw,unit,'mark3.upd',/get_lun
;
for i=1,52 do begin
	if jd_jan1+i*7 gt jd_today then break
	week=string(i,format='(i3.3)')
	file='bulletina-'+volume+'-'+week+'.txt'
	print,'Downloading '+file
	spawn,'wget '+link+file
;
	l=''
	status=dc_read_fixed(file,l,format='(a80)',/col)
	index=where(strpos(l,'IERS Rapid Service') ge 0,count)
	if count eq 0 then begin
		print,'Error: could not find line IERS Rapid Service'
		return
	endif
;	n_index=n_elements(index)
	j=3
	repeat begin
;		printf,unit,l(index(n_index-1)+j)
		printf,unit,l[max(index)+j]
		j=j+1
	endrep until strlen(strcompress(l[max(index)+j],/remove_all)) eq 0
;
endfor
free_lun,unit
;
cd,old_dir
;
end
