function ut12gst,utc,ut1,mean_t=mean_t,local=local
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Returns Greenwich apparent sidereal time (in hours).
; Calls calcsiderealtime in NOVAS C-library of astrometry subroutines
; (Kaplan, G.H. et al. 1989, AJ, 97, 1197).
; Input arrays, utc, and ut1 in seconds, should be type double.
; If no ut1 specified, default to utc. If mean_t=1, return mean time.
; If local=1, return local sidereal time.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if n_elements(ut1) eq 0 then ut1=utc
if n_elements(mean_t) eq 0 then mean_t=0L else mean_t=long(mean_t)
if n_elements(local) eq 0 then local=0
;
parsedate,Date,y,m,d
num_times=n_elements(UT1)
julianhi=dblarr(num_times)+long(julian(y,m,d))
julianlo=(UTC+GeoParms.TAI_UTC+GeoParms.TDT_TAI)/86400+0.5
TDT_UT1=utc-ut1+GeoParms.TAI_UTC+GeoParms.TDT_TAI
;
gst=dblarr(num_times)
status=linknload(!external_lib,'ut12gst',num_times,julianhi,julianlo,TDT_UT1, $
	gst,mean_t)
if status ne 0 then print,'***Error(UT12GST): NOVAS return error code',status
if local then gst=gst+geoparms.longitude/15
if n_elements(gst) eq 1 then return,gst[0] else return,gst
;
end
