pro uvimage,uv=uv,lambda=lambda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute and display (if uv keyword is set) an image of the visibility modulus
; given a uv-coverage and a model. Monochromatic, specify lambda [m].
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if n_elements(uv) eq 0 then uv=0
;
if n_elements(Date) eq 0 then begin
        print,'Warning(UVIMAGE): Date undefined!'
        parseidldate,systime(),y,m,d
        Date=nextdate(constrictordate(y,m,d))
        print,'Set date to: ',date
endif
if n_elements(SystemId) eq 0 then begin
        print,'Warning(UVIMAGE): SystemId undefined!'
        SystemId='NPOI'
        print,'Set SystemId to: ',SystemId
endif
;
if uv then begin
	i0=(!x.crange[0]*!x.s[1]+!x.s[0])*!d.x_size
	i1=(!x.crange[1]*!x.s[1]+!x.s[0])*!d.x_size
	j0=(!y.crange[0]*!y.s[1]+!y.s[0])*!d.y_size
	j1=(!y.crange[1]*!y.s[1]+!y.s[0])*!d.y_size
	imsze=[i1-i0+1,j1-j0+1]
	cellxsize=(abs(!x.crange[1]-!x.crange[0])/float(i1-i0))*1e6
	cellysize=(abs(!y.crange[1]-!y.crange[0])/float(j1-j0))*1e6
	pos=[i0,j0]
endif else begin
	imsze=[512,512]
	cellxsize=0.5e6
	cellysize=0.5e6
	cellxsize=8.0e6
	cellysize=8.0e6
	pos=[0,0]
endelse
;
if !d.name eq 'PS' then begin
	imsze=[456,456]
	cellxsize=40e6/imsze[0]
	cellysize=40e6/imsze[1]
endif
imsize=long(imsze)
cvf=complexarr(imsize[0],imsize[1])
u=(lindgen(imsize[0]*imsize[1]) mod imsize[0]) - (imsize[0]/2)
v=(lindgen(imsize[0]*imsize[1]) / imsize[0]) - (imsize[1]/2)
;
; Since we want the visibility image to be directly comparable
; to the source on the sky, we project it onto the sky just as
; plotuv has plotted it as projected onto the sky.
u=-u*cellxsize
v=+v*cellysize
;
; If no wavelength was specified, use a default
if n_elements(lambda) eq 0 then lambda=0.55e-6
; if n_elements(lambda) eq 0 then lambda=1.6e-6
;
; Display squared visibility amplitude in logarithmic scale
cvf[*]=modelvis(system_config(systemid,'MIDNIGHT')*3600,lambda,f,u,v)
map=abs(cvf)^2
; map=alog10(map/max(map)*1000+1)	; Rescale and add 1 to avoid log(0)
; map=byte(map/max(map)*127)
map=byte(map/max(map)*255)
; map=cphase(cvf)
; print,max(map),min(map)
; map=bytscl(map,max=2*!pi,min=-2*!pi)
;
if uv then begin
doco=0	; skip to Bob's code
if doco then begin
	tek_color
	u=-(findgen(imsize[0])-imsize[0]/2)*cellxsize/1e6
	v=+(findgen(imsize[1])-imsize[1]/2)*cellysize/1e6
	contour,map,u,v,levels=[0.25,0.5,0.75,0.9]^2*max(map),/over, $
			c_linestyle=[1,2,3,4]
endif else begin
;	Bob's code
	loadct,7
	device,set_graphics_function=7
	tv,map,pos[0],pos[1]
	device,set_graphics_function=3
;	Save the cvf,u and v data to a file
	outfile='uvimage.xdr'
	save,cvf,u,v,filename=outfile
	print,'uvimage data saved to ',outfile
; 	Use TVRD to save TV image to a png file
	filename = 'uvimage.png'
	WRITE_PNG, filename, TVRD(/TRUE)
	PRINT, 'File written to ', filename
endelse
endif else save,cvf,u,v
;
end
