function vanboekel,starid,lammda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return flux [Jy?] and lammda [m]
;
forward_function mrdfits
;
common StarBase,startable,notes
;
; Save any existing startable
if n_elements(startable) eq 0 then get_startable,starid
table=startable
;
; Get the information for the star
index=where(startable.starid eq starid,count)
if count eq 0 then begin
	get_startable,starid
	index=0
endif
type=startable[index[0]].type
class=startable[index[0]].class
;
xdrfile=!atmospheres_dir+'proprietary/vanboekel/'+'vBoekelDatabase.xdr'
file=file_search(xdrfile) & file=file[0]
if strlen(file) ne 0 then restore,file else begin
	fitsfile=!atmospheres_dir+'proprietary/vanboekel/'+'vBoekelDatabase.fits'
	fits_open,fitsfile,fcb
	index=where(fcb.extname eq 'SPECTROPHOTOMETRY',n)
	stars=strarr(n)
	fits_close,fcb
;
	d=mrdfits(fitsfile,index[0],header,/silent)
	wave=fltarr(n_elements(d.wavelength),n)
	flux=fltarr(n_elements(d.flux),n)
;
	for i=0,n-1 do begin
		d=mrdfits(fitsfile,index[i],header,/silent)
		stars[i]=cri_vlti(fitshparse(header,'NAME'))
		wave[*,i]=d.wavelength
		flux[*,i]=d.flux
	endfor
;
	get_startable,stars
	for i=0,n-1 do begin
		startable[i].wvl=wave[*,i]
		startable[i].sed=flux[*,i]
	endfor
	save,startable,filename=xdrfile
endelse
;
index=where(startable.starid eq starid,count)
if count eq 1 then begin
	print,'Found star in data base.'
	lammda=startable[index].wvl
	fluxes=startable[index].sed
endif else begin
;
	spec_parse,startable.spectrum,types,classes,t2,c2
;
; 	Find closest match in type for this class
	index=where(classes eq class,count)
	if count eq 0 then begin
		class=' class '+string(class,format='(i2)')+' ('+starid+')!'
		print,'Warning: substituting 5 (V) for unknown'+class
		class=5
		index=where(classes eq class)
	endif
;
	dt=abs(types[index]-type)
	jndex=where(dt eq min(dt)) & jndex=jndex[0]
	print,'Star not found, closest match: '+startable[jndex].starid
	lammda=startable[jndex].wvl
	fluxes=startable[jndex].sed
endelse
;
; Restore original startable, if needed
if n_elements(table) ne 0 then startable=table
;
; Return SED
return,fluxes
;
end
