function vcrit_mr,mass,radius_p
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute the critical (i.e., break-up) velocity of a star (km/s).
; See: Townsend, Owocki, and Howarth 2004, MNRAS 350, 189, Table 1
; Input mass & radius in solar units. Radius is the polar radius.
;
G=191e3
return,sqrt(2*G*mass/(3*radius_p))
;
end
