function vel2gamma,velocities,mass_a,mass_b
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Given velocities (ameeba structure!), primary and secondary mass, compute
; gamma velocities for matching pairs of measurement.
;
ujds=unique(velocities.jd)
n_ujds=n_elements(ujds)
v_gamma=fltarr(n_ujds)
j_gamma=fltarr(n_ujds)
for i=0,n_ujds-1 do begin
	i_a=where(velocities.jd eq ujds[i] and velocities.component eq 'A',n_a)
	i_b=where(velocities.jd eq ujds[i] and velocities.component eq 'B',n_b)
	if n_a eq 1 and n_b eq 1 then begin
		v_gamma[i]=(mass_a*velocities[i_a].value $
			   +mass_b*velocities[i_b].value)/(mass_a+mass_b)
		j_gamma[i]=ujds[i]
	endif
endfor
;
index=where(v_gamma ne 0,count)
if count eq 0 then begin
	print,'Error: no matching RV observations!'
	return,0
endif else begin
	jd=j_gamma[index]+2440000.d0
	rv=v_gamma[index]
	for i=0,count-1 do $
	print,'AB   '+string(jd[i],format='(f11.3)')+' '+string(rv[i])+' 1.0'
	return,{rv:rv,jd:jd}
endelse
;
end
