pro vel2tex,aas=aas
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Prepare LaTeX file from radial velocity data of a binary.
; Must load data and read model first (for computing (O-C) values).
; Prepare in A&A LaTex format (or AAS if aas=1).
;
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
;
if n_elements(aas) eq 0 then aas=0
;
if n_elements(velocities) eq 0 then begin
	print,'***Error(VEL2TEX): no RVs!'
	return
endif
if n_elements(gen_model) eq 0 then begin
	print,'***Error(VEL2TEX): no model!'
	return
endif
;
openw,unit,gen_model.starid+'_vel.tex',/get_lun
;
months=['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec']
;
IF aas THEN BEGIN
;
; AJ and ApJ
;
printf,unit,'\documentclass{/home/chummel/latex/aastex6/aastex}'
printf,unit,'\begin{document}'
printf,unit,'\begin{deluxetable}{rllrrrrrr}'
printf,unit,'\tablecaption{Radial velocity result log for '+gen_model.starid+'\l
;
printf,unit,'\tablehead{'
;
printf,unit,'\colhead{}&'
printf,unit,'\colhead{Julian}&'
printf,unit,'\colhead{}&'
printf,unit,'\multicolumn{3}{c}{Primary RVs [km/s]}&'
printf,unit,'\multicolumn{3}{c}{Secondary RVs [km/s]}'
printf,unit,'\\'
printf,unit,'\colhead{Date}&'
printf,unit,'\colhead{Year}&'
printf,unit,'\colhead{MJD}&'
printf,unit,'\colhead{RV}&'
printf,unit,'\colhead{$\sigma$}&'
printf,unit,'\colhead{$(O-C)$}&'
printf,unit,'\colhead{RV}&'
printf,unit,'\colhead{$\sigma$}&'
printf,unit,'\colhead{$(O-C)$}'
printf,unit,'}'
;
jds=unique(velocities.jd)
;
printf,unit,'\startdata'
;
for i=0,n_elements(jds)-1 do begin
	i_a=where(velocities.jd eq jds[i] and velocities.component eq 'A',a_c)
	i_b=where(velocities.jd eq jds[i] and velocities.component eq 'B',b_c)
	if a_c eq 1 then index=i_a else index=i_b
	parsedate,velocities[index].date,y,m,d
	month=months[long(strmid(velocities[index].date,5,2))-1]
	day=strmid(velocities[index].date,8,2)
	if a_c+b_c eq 2 then begin
	printf,unit,month+' '+day+'\dotfill', $
		jd2jy(velocities[index].jd+2440000.d0), $
		velocities[index].jd+39999.5d0, $
		velocities[i_a].value, $
		velocities[i_a].error, $
		velocities[i_a].value-velocities[i_a].valuem, $
		velocities[i_b].value, $
		velocities[i_b].error, $
		velocities[i_b].value-velocities[i_b].valuem, $
		format='(a,"&",f9.4,"&",f9.2,"&$",f5.1,"$&$",f4.1,"$&$",f4.1,"$&$",f5.1,"$&$",
	endif else if a_c eq 1 then begin
	printf,unit,month+' '+day+'\dotfill', $
		jd2jy(velocities[index].jd+2440000.d0), $
		velocities[i_a].jd+39999.5d0, $
		velocities[i_a].value, $
		velocities[i_a].error, $
		velocities[i_a].value-velocities[i_a].valuem, $
		format='(a,"&",f9.4,"&",f9.2,"&$",f5.1,"$&$",f4.1,"$&$",f5.2,"$&","&","&","\\"
	endif else begin
	printf,unit,month+' '+day+'\dotfill', $
		jd2jy(velocities[index].jd+2440000.d0), $
		velocities[i_b].jd+39999.5d0, $
		velocities[i_b].value, $
		velocities[i_b].error, $
		velocities[i_b].value-velocities[i_b].valuem, $
		format='(a,"&",f9.4,"&",f9.2,"&","&","&","&$",f5.1,"$&$",f4.1,"$&$",f4.1,"$","
	endelse
endfor
;
printf,unit,'\enddata'
printf,unit,'\end{deluxetable}'
;
ENDIF ELSE BEGIN
;
; Version not using aastex
printf,unit,'\documentstyle[12pt]{article}'
printf,unit,'\renewcommand{\baselinestretch}{1.0}'
printf,unit,'\begin{document}'
printf,unit,'\begin{table}'
printf,unit,'\caption{Observation and result log for '+gen_model.starid+'}'
printf,unit,'\begin{tabular}{lllrrrrrrr}'
;
printf,unit,'&'+ $
	    '\multicolumn{1}{c}{Julian}&'+ $
	    '&'+ $
	    '\multicolumn{3}{c}{Primary}&'+ $
	    '\multicolumn{3}{c}{Secondary}\\'
printf,unit,'\multicolumn{1}{c}{Date}&'+ $
	    '\multicolumn{1}{c}{Year}&'+ $
	    '\multicolumn{1}{c}{MJD}&'+ $
	    '\multicolumn{1}{c}{[km/s]}&'+ $
	    '\multicolumn{1}{c}{$\pm$}&'+ $
	    '\multicolumn{1}{c}{$(O-C)$}&'+ $
	    '\multicolumn{1}{c}{[km/s]}&'+ $
	    '\multicolumn{1}{c}{$\pm$}&'+ $
	    '\multicolumn{1}{c}{$(O-C)$}&'+ $
            '\multicolumn{1}{c}{Observatory}\\ \tableline'
;
printf,unit,month+' '+day+'\dotfill', $
		jd2jy(velocities[index[i]].jd+2440000.d0), $
		velocities[index[i]].jd+39999.5d0, $
		velocities[index[i]].value,velocities[index[i]].error, $
		velocities[index[i]].value-velocities[index[i]].valuem, $
		velocities[index].value,velocities[index].error, $
		velocities[index].value-velocities[index].valuem, $
		velocities[index[i]].comment, $
		format='(a,"&",f9.4,"&",f9.2,"&",f5.1,"&",f5.2,"&",f5.2,"&",f5.1,"&",f5.2,"&",
;
printf,unit,'\tableline \tableline'
printf,unit,'\end{tabular}'
printf,unit,'\end{table}'
;
ENDELSE
;
printf,unit,'\end{document}'
free_lun,unit
;
end
