pro vignet,stations
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Display telescope shadows
;
n_az=37L
n_el=19L
az=dindgen(n_az)*360/(n_az-1)
el=dindgen(n_el)*90/(n_el-1)
r=fltarr(n_az*n_el)
t=fltarr(n_az*n_el)
;
for i=0,n_elements(stations)-1 do begin
shadow=dblarr(n_az*n_el)
;
loc=vlti_station(stations[i],ts)
;
; The AZ for shadow is zero for S and increasing Eastwards
status=linknload(!external_lib,'shadow',n_az,n_el,az,el,shadow,loc,r,t,ts)
;
if i eq 0 then z=shadow else z=z+shadow
;
endfor
;
z=z*127
;
loadct,0
i0=(!x.crange[0]*!x.s[1]+!x.s[0])*!d.x_size
i1=(!x.crange[1]*!x.s[1]+!x.s[0])*!d.x_size
j0=(!y.crange[0]*!y.s[1]+!y.s[0])*!d.y_size
j1=(!y.crange[1]*!y.s[1]+!y.s[0])*!d.y_size
imsze=[i1-i0+1,j1-j0+1]
device,set_graphics_function=6
tvscl,congrid(polar_surface(z,r,t),imsze[0],imsze[1]),i0,j0
; polar_contour,z,t,r,nlevels=8,fill=1,/over
device,set_graphics_function=3
;
end
