function vinci_c,lambda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Based on code by M. Wittkowski, but modified for units of wavelength
; intervals rather than frequency intervals. The VINCI filter function,
; due to specific data reduction, was expressed over a grid of equidistant
; frequencies, but OYSTER in general uses grids equidistant in wavelength.
; Therefore, we have to multiply the VINCI numbers with c/lambda^2.
;
; 2005-06-09: incorrect, since this is a response and not an energy,
; no such normalization is necessary: see commented ;/l^2 below!
;
; Superceded by vinci_k
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
c=2.9979E8
n=66
wn=(findgen(n)*20.)+3980.d
wn=wn*1e2*c
l=c/wn*1e9
T=[0.00,0.00038, 0.00032, 0.00072, 0.00126, 0.00213, 0.00385, 0.00493,$
0.00456, 0.00887, 0.01196, 0.01549, 0.02290, 0.02773, 0.02839, 0.02880,$
0.03139, 0.02972, 0.03028, 0.02856, 0.02770, 0.02896, 0.02801, 0.02792,$
0.02753, 0.02728, 0.02668, 0.02627, 0.02588, 0.02449, 0.02567, 0.02566,$
0.02604, 0.02544, 0.02478, 0.02422, 0.02379, 0.02241, 0.02200, 0.02200,$
0.02163, 0.02069, 0.02017, 0.01678, 0.01719, 0.01506, 0.01506, 0.01650,$
0.01638, 0.01240, 0.00997, 0.00950, 0.00950, 0.01117, 0.00763, 0.00520,$
0.00520, 0.00251, 0.00157, 0.00064, 0.00064, 0.00041, 0.00002, 0.00010,$
0.00010, 0.00];/l^2
T=T/total(T)
;
return,response(l,t,lambda)
;
end
