function vinci_k,lambda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Based on code by M. Wittkowski, but modified for units of wavelength
; intervals rather than frequency intervals. The VINCI filter function,
; due to specific data reduction, was expressed over a grid of equidistant
; frequencies, but OYSTER in general uses grids equidistant in wavelength.
;
; This wavelength based version uses numbers from Pierre Kervella.
; lambda in nm.
;
n=62
l=1900+(findgen(n)*10.)
T=[0.00,0.01,0.00,0.04,0.06,0.16,0.25,0.52,0.76,1.12,0.95,1.00,1.24,1.64,$
   1.65,1.51,1.72,1.68,2.02,2.07,2.16,2.20,2.24,2.38,2.42,2.48,2.54,2.60,$
   2.57,2.57,2.45,2.59,2.63,2.67,2.73,2.75,2.79,2.80,2.90,2.77,2.86,$
   3.03,2.97,3.14,2.88,2.84,2.77,2.29,1.88,1.55,1.20,0.89,0.46,$
   0.49,0.39,0.27,0.21,0.13,0.07,0.03,0.04,0.00]
T=T/total(T)
;
if n_elements(lambda) eq 0 then begin
	lambda=l
	return,total(l*t)/total(t)
endif
return,response(l,t,lambda)
;
end
