function viscalerror,d,de,bl=bl,wl=wl
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Computes the error in the visibility caused by an error in the
; calibrator diameter. bl [m], wl [m]
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
factor=(pi_circle^2)/(180L*3600L*1000L)
;
if n_elements(bl) eq 0 then bl=100.0  	; m
if n_elements(wl) eq 0 then wl=10e-6    ; m
uvdist=bl/wl
n=n_elements(d)
UD=d
arg=factor*uvdist*(UD-de)
visamp=2*beselj(arg,1)/arg
vissql=visamp^2
arg=factor*uvdist*(UD+de)
visamp=2*beselj(arg,1)/arg
vissqh=visamp^2
return,(abs(vissqh-vissql)/((vissqh+vissql)/2))*100
;
end
