function visrotate,vis,l,d,air,glass
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Rotate complex visibility by group delay d and (optionally) air path a.
; The delay can be a vector, in which case the same delay applies to every
; wavelength l, or a 2-dimensional array, with the first dimension
; corresponding to l.
;
; l = wavelength [m]
; d = group delay [m]
; air = airpath [m]
; glass = path through glass [m] (if defined, so must be air
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
if n_elements(d) eq 1 then g=[d] else g=reform(d)
if n_elements(air) eq 0 then air=g*0
n_air=edlen(l*1e6)
if n_elements(glass) eq 0 then glass=g*0
n_glass=silica(l*1e6)
g=reform((l*0+1)#g+(n_air-1)#air+(n_glass-1)#glass,n_elements(l),n_elements(d))
;
r=size(g)
if r[0] eq 1 then p=float(2*pi_circle*(1/l)#g) $
	     else begin
		  p=reform(float(vis))
		  for j=0,n_elements(l)-1 do p[j,*]=2*pi_circle*g[j,*]/l[j]
		  endelse
;
vis_r=reform(vis)*exp(i_complex*p)
;
return,vis_r
;
end
